/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import org.apache.commons.lang3.StringUtils;

public class HtmlItem {
    @Nonnull
    protected String itemPropertyPath;
    protected String itemKindIdClass;
    @Nonnull
    protected String itemKindIdField;
    protected String itemNameKeyClass;
    protected String itemNameKeyField;
    protected HtmlItemConditionContainer<Boolean> isNotEmpty = new HtmlItemConditionContainer<Boolean>(false);

    public HtmlItem(@RequireNonempty String itemPropertyPath) {
        String propertyPathWithoutFarRightPart;
        this.itemPropertyPath = ObjectsUtil.requireNonEmpty((String)itemPropertyPath);
        String string = propertyPathWithoutFarRightPart = itemPropertyPath.contains(".") ? itemPropertyPath.substring(0, itemPropertyPath.lastIndexOf(".")) : null;
        this.itemKindIdClass = propertyPathWithoutFarRightPart == null ? null : (propertyPathWithoutFarRightPart.contains(".") ? propertyPathWithoutFarRightPart.substring(itemPropertyPath.lastIndexOf(".") + 1) : propertyPathWithoutFarRightPart);
        this.itemKindIdField = itemPropertyPath.contains(".") ? itemPropertyPath.substring(itemPropertyPath.lastIndexOf(".") + 1) : itemPropertyPath;
    }

    public String getItemPropertyPath() {
        return this.itemPropertyPath;
    }

    public String getItemKindId(String rootRecordName) {
        return (StringUtils.isEmpty((CharSequence)this.itemKindIdClass) ? rootRecordName : this.itemKindIdClass) + "." + this.itemKindIdField;
    }

    public HtmlItem itemNameKey(@RequireNonempty String itemNameKey) {
        ObjectsUtil.requireNonEmpty((String)itemNameKey);
        this.itemNameKeyClass = itemNameKey.contains(".") ? itemNameKey.substring(0, itemNameKey.lastIndexOf(".")) : null;
        this.itemNameKeyField = itemNameKey.contains(".") ? itemNameKey.substring(itemNameKey.lastIndexOf(".") + 1) : itemNameKey;
        return this;
    }

    public String getItemNameKey(String rootRecordName) {
        String classPart = !StringUtils.isEmpty((CharSequence)this.itemNameKeyClass) ? this.itemNameKeyClass : (!StringUtils.isEmpty((CharSequence)this.itemKindIdClass) ? this.itemKindIdClass : rootRecordName);
        String fieldPart = !StringUtils.isEmpty((CharSequence)this.itemNameKeyField) ? this.itemNameKeyField : this.itemKindIdField;
        return classPart + "." + fieldPart;
    }

    public HtmlItem isNotEmpty(boolean isNotEmpty) {
        this.isNotEmpty.setDefaultValue(isNotEmpty);
        return this;
    }

    public HtmlItem isNotEmpty(HtmlItemConditionKeyEnum authKind, String authString, boolean isNotEmpty) {
        this.isNotEmpty.add(new HtmlItemCondition<Boolean>(authKind, authString, isNotEmpty));
        return this;
    }

    public boolean getIsNotEmpty(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isNotEmpty.getValue(loginState, bean);
    }

    public static class HtmlItemConditionContainer<T> {
        private List<HtmlItemCondition<T>> list = new ArrayList<HtmlItemCondition<T>>();
        private T defaultValue;

        public HtmlItemConditionContainer(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void add(HtmlItemCondition<T> authInfo) {
            this.getList().add(authInfo);
        }

        private List<HtmlItemCondition<T>> getList() {
            return this.list;
        }

        public void setList(List<HtmlItemCondition<T>> list) {
            this.list = list;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getValue(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
            if (this.list == null) {
                this.list = new ArrayList<HtmlItemCondition<T>>();
            }
            for (HtmlItemCondition<T> info : this.list) {
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.LOGIN_STATE) {
                    if (!info.getConditionValue().equals(loginState)) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.ROLE_CONTAINS) {
                    if (!bean.getRoleList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.AUTHORITY_CONTAINS) {
                    if (!bean.getAuthorityList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                throw new RuntimeException("Set appropriate one of the AuthKindEnum values");
            }
            return this.defaultValue;
        }
    }

    public static class HtmlItemCondition<T> {
        private HtmlItemConditionKeyEnum conditionKey;
        private String conditionValue;
        private T value;

        public HtmlItemCondition(HtmlItemConditionKeyEnum conditionKey, String conditionValue, T value) {
            this.conditionKey = conditionKey;
            this.conditionValue = conditionValue;
            this.value = value;
        }

        public HtmlItemConditionKeyEnum getConditionKey() {
            return this.conditionKey;
        }

        public String getConditionValue() {
            return this.conditionValue;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static enum HtmlItemConditionKeyEnum {
        LOGIN_STATE,
        ROLE_CONTAINS,
        AUTHORITY_CONTAINS;

    }
}

