/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.advice;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import jp.ecuacion.splib.web.bean.MessagesBean;
import jp.ecuacion.splib.web.bean.SplibModelAttributes;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.util.SplibUtil;
import jp.ecuacion.splib.web.util.internal.TransactionTokenUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class SplibControllerAdvice {
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SplibModelAttributes modelAttr;
    @Autowired
    private SplibUtil util;

    @ModelAttribute
    public void modelAttribute(Model model) {
        this.request.setAttribute("model", (Object)model);
        this.recoverRequestParametersFromRedirectContextId(model);
        model.addAttribute("transactionToken", (Object)new TransactionTokenUtil().issueNewToken(this.request));
        model.addAttribute("loginState", (Object)this.util.getLoginState());
        this.modelAttr.addAllToModel(model);
    }

    private void recoverRequestParametersFromRedirectContextId(Model model) {
        Map contextMap;
        boolean takesOverContext = true;
        String contextId = this.request.getParameter("contextId");
        if (contextId == null || contextId.equals("")) {
            takesOverContext = false;
        }
        if ((contextMap = (Map)this.request.getSession().getAttribute("contextId-" + contextId)) == null) {
            takesOverContext = false;
        }
        if (takesOverContext) {
            Map modelMapRedirectFrom = ((Model)contextMap.get("model")).asMap();
            modelMapRedirectFrom.remove("messagesBean");
            model.addAllAttributes(modelMapRedirectFrom);
            model.addAttribute("messagesBean", contextMap.get("messagesBean"));
            model.asMap().entrySet().stream().filter(e -> e.getValue() instanceof SplibGeneralForm).forEach(e -> ((SplibGeneralForm)e.getValue()).noValidate());
            this.request.getSession().removeAttribute("contextId-" + contextId);
        }
        if (model.getAttribute("messagesBean") == null) {
            model.addAttribute("messagesBean", (Object)new MessagesBean());
        }
    }
}

