/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public class HtmlItem {
    protected String propertyPath;
    @Nonnull
    protected String itemKindIdField;
    protected String itemKindIdFieldForName;
    protected HtmlItemConditionContainer<Boolean> isNotEmpty = new HtmlItemConditionContainer<Boolean>(false);

    public HtmlItem(String propertyPath) {
        this.propertyPath = propertyPath;
        this.itemKindIdField = propertyPath;
    }

    public String getPropertyPath() {
        return this.propertyPath;
    }

    public String getItemKindIdField() {
        return this.itemKindIdField;
    }

    public HtmlItem itemKindIdFieldForName(String itemKindIdFieldForName) {
        this.itemKindIdFieldForName = itemKindIdFieldForName;
        return this;
    }

    public String getItemKindIdFieldForName() {
        return this.itemKindIdFieldForName;
    }

    public HtmlItem isNotEmpty(boolean isNotEmpty) {
        this.isNotEmpty.setDefaultValue(isNotEmpty);
        return this;
    }

    public HtmlItem isNotEmpty(HtmlItemConditionKeyEnum authKind, String authString, boolean isNotEmpty) {
        this.isNotEmpty.add(new HtmlItemCondition<Boolean>(authKind, authString, isNotEmpty));
        return this;
    }

    public boolean getIsNotEmpty(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isNotEmpty.getValue(loginState, bean);
    }

    public static class HtmlItemConditionContainer<T> {
        private List<HtmlItemCondition<T>> list = new ArrayList<HtmlItemCondition<T>>();
        private T defaultValue;

        public HtmlItemConditionContainer(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void add(HtmlItemCondition<T> authInfo) {
            this.getList().add(authInfo);
        }

        private List<HtmlItemCondition<T>> getList() {
            return this.list;
        }

        public void setList(List<HtmlItemCondition<T>> list) {
            this.list = list;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getValue(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
            if (this.list == null) {
                this.list = new ArrayList<HtmlItemCondition<T>>();
            }
            for (HtmlItemCondition<T> info : this.list) {
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.LOGIN_STATE) {
                    if (!info.getConditionValue().equals(loginState)) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.ROLE) {
                    if (!bean.getRoleList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.AUTHORITY) {
                    if (!bean.getAuthorityList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.KEYWORD) {
                    if (!bean.getAuthorityList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                throw new RuntimeException("Set appropriate one of the AuthKindEnum values");
            }
            return this.defaultValue;
        }
    }

    public static class HtmlItemCondition<T> {
        private HtmlItemConditionKeyEnum conditionKey;
        private String conditionValue;
        private T value;

        public HtmlItemCondition(HtmlItemConditionKeyEnum conditionKey, String conditionValue, T value) {
            this.conditionKey = conditionKey;
            this.conditionValue = conditionValue;
            this.value = value;
        }

        public HtmlItemConditionKeyEnum getConditionKey() {
            return this.conditionKey;
        }

        public String getConditionValue() {
            return this.conditionValue;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static enum HtmlItemConditionKeyEnum {
        LOGIN_STATE,
        ROLE,
        AUTHORITY,
        KEYWORD;

    }
}

