/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.item;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jp.ecuacion.lib.core.item.Item;
import jp.ecuacion.lib.core.item.ItemContainer;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.item.HtmlItem;
import jp.ecuacion.splib.web.item.HtmlItemNumber;
import jp.ecuacion.splib.web.item.HtmlItemString;
import jp.ecuacion.splib.web.record.StringMatchingConditionBean;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public interface HtmlItemContainer
extends ItemContainer {
    public HtmlItem[] getHtmlItems();

    default public HtmlItem[] customizedItems() {
        return this.getHtmlItems();
    }

    default public HtmlItem[] mergeHtmlItems(HtmlItem[] items1, HtmlItem[] items2) {
        Item[] items = this.mergeItems(items1, items2);
        List<HtmlItem> list = Arrays.asList(items).stream().map(item -> (HtmlItem)((Object)item)).toList();
        return list.toArray(new HtmlItem[list.size()]);
    }

    default public HtmlItem getHtmlItem(String itemPropertyPath) {
        return (HtmlItem)this.getItem(itemPropertyPath);
    }

    default public HtmlItem getNewItem(String itemPropertyPath) {
        return new HtmlItem(itemPropertyPath);
    }

    default public boolean needsCommas(String rootRecordName, String itemPropertyPath) {
        HtmlItem item = this.getHtmlItem(itemPropertyPath);
        if (item == null || !(item instanceof HtmlItemNumber)) {
            return false;
        }
        HtmlItemNumber numItem = (HtmlItemNumber)item;
        return numItem.getNeedsCommas();
    }

    default public List<String> getNotEmptyItemPropertyPathList(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmpty(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    default public boolean isNotEmpty(String itemPropertyPath, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getNotEmptyItemPropertyPathList(loginState, bean).contains(itemPropertyPath);
    }

    default public List<String> getNotEmptyOnSearchItemPropertyPathList(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmptyOnSearch(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    default public boolean isNotEmptyOnSearch(String itemPropertyPath, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getNotEmptyOnSearchItemPropertyPathList(loginState, bean).contains(itemPropertyPath);
    }

    default public Map<String, StringMatchingConditionBean> getSearchPatterns() {
        HtmlItem[] htmlItems;
        HashMap<String, StringMatchingConditionBean> map = new HashMap<String, StringMatchingConditionBean>();
        for (HtmlItem item : htmlItems = this.getHtmlItems()) {
            if (!(item instanceof HtmlItemString) || ((HtmlItemString)item).getStringSearchPatternEnum() == null) continue;
            HtmlItemString itemStr = (HtmlItemString)item;
            map.put(item.getItemPropertyPath(), new StringMatchingConditionBean(itemStr.getStringSearchPatternEnum(), itemStr.isIgnoresCase()));
        }
        return map;
    }

    default public String getSearchPatternComment(Locale locale, String itemPropertyPath) {
        StringMatchingConditionBean bean = this.getSearchPatterns().get(itemPropertyPath);
        if (bean == null) {
            throw new RuntimeException("The stringMatchingCondition of the field '" + itemPropertyPath + "' not set'. At least you need to add '" + itemPropertyPath + "' to the getHtmlItems() in 'xxxSearchRecord or it's parent Record.");
        }
        String commentMessageId = StringUtil.getLowerCamelFromSnake((String)bean.getStringSearchPatternEnum().toString());
        return PropertyFileUtil.getMessage((Locale)locale, (String)("jp.ecuacion.splib.web.common.label.searchPattern." + commentMessageId + "Match"), (String[])new String[0]);
    }
}

