/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.item;

import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.item.Item;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public class HtmlItem
extends Item {
    protected HtmlItemConditionContainer<Boolean> isNotEmpty = new HtmlItemConditionContainer<Boolean>(false);
    protected HtmlItemConditionContainer<Boolean> isNotEmptyOnSearch = new HtmlItemConditionContainer<Boolean>(false);

    public HtmlItem(String itemPropertyPath) {
        super(itemPropertyPath);
    }

    public HtmlItem itemNameKey(@RequireNonempty String itemNameKey) {
        return (HtmlItem)super.itemNameKey(itemNameKey);
    }

    public HtmlItem hideValue() {
        return (HtmlItem)super.hideValue();
    }

    public HtmlItem notEmpty() {
        this.isNotEmpty.setDefaultValue(true);
        return this;
    }

    public HtmlItem isNotEmpty(boolean isNotEmpty) {
        this.isNotEmpty.setDefaultValue(isNotEmpty);
        return this;
    }

    public HtmlItem isNotEmpty(HtmlItemConditionKeyEnum authKind, String authString, boolean isNotEmpty) {
        this.isNotEmpty.add(new HtmlItemCondition<Boolean>(authKind, authString, isNotEmpty));
        return this;
    }

    public boolean getIsNotEmpty(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isNotEmpty.getValue(loginState, bean);
    }

    public HtmlItem notEmptyOnSearch() {
        this.isNotEmptyOnSearch.setDefaultValue(true);
        return this;
    }

    public HtmlItem isNotEmptyOnSearch(boolean isRequired) {
        this.isNotEmptyOnSearch.setDefaultValue(isRequired);
        return this;
    }

    public HtmlItem isNotEmptyOnSearch(HtmlItemConditionKeyEnum authKind, String authString, boolean isRequired) {
        this.isNotEmptyOnSearch.add(new HtmlItemCondition<Boolean>(authKind, authString, isRequired));
        return this;
    }

    public boolean getIsNotEmptyOnSearch(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isNotEmptyOnSearch.getValue(loginState, bean);
    }

    public static class HtmlItemConditionContainer<T> {
        private List<HtmlItemCondition<T>> list = new ArrayList<HtmlItemCondition<T>>();
        private T defaultValue;

        public HtmlItemConditionContainer(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void add(HtmlItemCondition<T> authInfo) {
            this.getList().add(authInfo);
        }

        private List<HtmlItemCondition<T>> getList() {
            return this.list;
        }

        public void setList(List<HtmlItemCondition<T>> list) {
            this.list = list;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getValue(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
            if (this.list == null) {
                this.list = new ArrayList<HtmlItemCondition<T>>();
            }
            for (HtmlItemCondition<T> info : this.list) {
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.LOGIN_STATE) {
                    if (!info.getConditionValue().equals(loginState)) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.ROLE_CONTAINS) {
                    if (!bean.getRoleList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.AUTHORITY_CONTAINS) {
                    if (!bean.getAuthorityList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                throw new RuntimeException("Set appropriate one of the AuthKindEnum values");
            }
            return this.defaultValue;
        }
    }

    public static class HtmlItemCondition<T> {
        private HtmlItemConditionKeyEnum conditionKey;
        private String conditionValue;
        private T value;

        public HtmlItemCondition(HtmlItemConditionKeyEnum conditionKey, String conditionValue, T value) {
            this.conditionKey = conditionKey;
            this.conditionValue = conditionValue;
            this.value = value;
        }

        public HtmlItemConditionKeyEnum getConditionKey() {
            return this.conditionKey;
        }

        public String getConditionValue() {
            return this.conditionValue;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static enum HtmlItemConditionKeyEnum {
        LOGIN_STATE,
        ROLE_CONTAINS,
        AUTHORITY_CONTAINS;

    }
}

