/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.jakartavalidation.bean.ConstraintViolationBean;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.bean.ReturnUrlBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.controller.SplibGeneral1FormController;
import jp.ecuacion.splib.web.controller.SplibGeneral2FormsController;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneral1FormService;
import jp.ecuacion.splib.web.service.SplibGeneral2FormsService;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class SplibGeneralController<S extends SplibGeneralService>
extends SplibBaseController {
    @Autowired
    protected HttpServletResponse response;
    protected ControllerContext context;
    protected SplibSecurityUtil.RolesAndAuthoritiesBean rolesAndAuthoritiesBean;
    @Autowired
    protected List<S> serviceList;
    @Autowired
    private SplibUtil util;
    protected ReturnUrlBean redirectUrlOnAppExceptionBean;
    protected List<String[]> paramListOnRedirectToSelf = new ArrayList<String[]>();

    protected void addCookieForDownloadButton() {
        Cookie cookie = new Cookie("download_status", "completed");
        cookie.setPath("/");
        this.response.addCookie(cookie);
    }

    public static ControllerContext newContext() {
        return new ControllerContext();
    }

    public S getService() {
        Class cls = null;
        cls = this instanceof SplibGeneral1FormController ? SplibGeneral1FormService.class : (this instanceof SplibGeneral2FormsController ? SplibGeneral2FormsService.class : SplibGeneralService.class);
        Class<SplibGeneral1FormService> cls2 = cls;
        List<SplibGeneralService> list = this.serviceList.stream().filter(e -> cls2.isAssignableFrom(e.getClass())).toList();
        if (list.size() != 1) {
            throw new RuntimeException("Injected service not 1.");
        }
        return (S)list.get(0);
    }

    public SplibGeneralController(@Nonnull String function) {
        this(function, SplibGeneralController.newContext());
    }

    protected SplibGeneralController(@Nonnull String function, @NonNull ControllerContext context) {
        context.function(function);
        this.context = context;
    }

    public String[] getFunctionKinds() {
        return this.context.functionKinds();
    }

    public String getFunction() {
        return this.context.function();
    }

    public String getSubFunction() {
        return this.context.subFunction();
    }

    public String getRootRecordName() {
        return this.context.mainRootRecordName();
    }

    public ReturnUrlBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    protected void addParamToParamListOnRedirectToSelf(String key) {
        this.paramListOnRedirectToSelf.add(new String[]{key, ""});
    }

    protected void addParamToParamListOnRedirectToSelf(String key, String value) {
        this.paramListOnRedirectToSelf.add(new String[]{key, value});
    }

    public List<String[]> getParamListOnRedirectToSelf() {
        return this.paramListOnRedirectToSelf;
    }

    @ModelAttribute
    private void setParamsToModel(Model model, @AuthenticationPrincipal UserDetails loginUser) {
        model.addAttribute("functionKindsPathString", this.context.functionKinds().length == 0 ? "" : StringUtil.getSeparatedValuesString((String[])this.context.functionKinds(), (String)"/") + "/");
        model.addAttribute("function", (Object)this.context.function());
        model.addAttribute("mainRootRecordName", (Object)this.context.mainRootRecordName());
        model.addAttribute("rootRecordName", (Object)this.context.mainRootRecordName());
        this.rolesAndAuthoritiesBean = loginUser == null ? new SplibSecurityUtil().getRolesAndAuthoritiesBean() : new SplibSecurityUtil().getRolesAndAuthoritiesBean(loginUser);
        model.addAttribute("rolesAndAuthorities", (Object)this.rolesAndAuthoritiesBean);
    }

    protected String getRedirectUrlOnSuccess() {
        return new ReturnUrlBean(this, this.util).showSuccessMessage().getUrl();
    }

    public String redirectToSamePageTakingOverModel(Model model) {
        return this.redirectToSamePageTakingOverModel(model, false);
    }

    public String redirectToSamePageTakingOverModel(Model model, boolean showsSuccessMessage) {
        ReturnUrlBean bean = new ReturnUrlBean(this, this.util);
        if (showsSuccessMessage) {
            bean.showSuccessMessage();
        }
        return this.util.prepareForPageTransition(this.request, bean, model, false);
    }

    public String getDefaultHtmlPageName() {
        String functionKindPath = this.context.functionKinds().length == 0 ? "" : StringUtil.getSeparatedValuesString((String[])this.context.functionKinds(), (String)"/") + "/";
        return functionKindPath + this.context.function() + StringUtils.capitalize((String)(this.context.htmlFilenamePostfix() == null ? this.context.subFunction() : this.context.htmlFilenamePostfix()));
    }

    public String getDefaultDestSubFunctionOnNormalEnd() {
        return this.context.subFunction();
    }

    public String getDefaultDestSubFunctionOnAbnormalEnd() {
        return this.context.subFunction();
    }

    public String getDefaultDestPageOnNormalEnd() {
        return "page";
    }

    public String getDefaultDestPageOnAbnormalEnd() {
        return "page";
    }

    public void prepare(Model model, SplibGeneralForm ... forms) throws AppException {
        this.prepare(model, (UserDetails)null, forms);
    }

    public void prepare(Model model, UserDetails loginUser, SplibGeneralForm ... forms) throws AppException {
        for (SplibGeneralForm form : forms) {
            model.addAttribute((Object)form);
            form.setControllerContext(this.context);
        }
        model.addAttribute("forms", (Object)forms);
        model.addAttribute("controller", (Object)this);
        this.transactionTokenCheck();
        for (SplibGeneralForm form : forms) {
            if (!form.getPrepareSettings().validates()) continue;
            this.validationCheck(form, form.getPrepareSettings().bindingResult(), this.util.getLoginState(), this.rolesAndAuthoritiesBean);
        }
    }

    private void transactionTokenCheck() throws BizLogicAppException {
        String forward = this.request.getParameter("forward");
        if (forward != null && forward.equals("true")) {
            return;
        }
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new BizLogicAppException(msgId, new String[0]);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result, String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) throws MultipleAppException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError(loginState, bean);
        ArrayList<ValidationAppException> exList = new ArrayList<ValidationAppException>();
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            List<ValidationAppException> list = this.getBeanValidationAppExceptionList(form, bean);
            exList.addAll(list);
            throw new MultipleAppException(exList);
        }
    }

    private List<ValidationAppException> getBeanValidationAppExceptionList(SplibGeneralForm form, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        ArrayList<ConstraintViolationBean<?>> errorList = new ArrayList<ConstraintViolationBean>();
        for (ConstraintViolation cv : Validation.buildDefaultValidatorFactory().getValidator().validate((Object)form, new Class[0])) {
            errorList.add(new ConstraintViolationBean(cv));
        }
        errorList.addAll(form.validateNotEmpty(this.request.getLocale(), this.util.getLoginState(), bean).stream().collect(Collectors.toList()));
        errorList = errorList.stream().sorted(this.getComparator()).collect(Collectors.toList());
        this.removeDuplicatedValidators(errorList);
        if (errorList.size() == 0) {
            String msg = "SplibExceptionHandler#handleInputValidationException\u306b\u6765\u3066\u3044\u308b\u306e\u306berrorList\u306b\u30a8\u30e9\u30fc\u9805\u76ee\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\nrootRecoordName\u3068\u540c\u4e00\u306ename\u3092\u6301\u3063\u305fsubmit\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u305f\u5834\u5408\u306b\u767a\u751f\u3059\u308b\u6a21\u69d8\u3002\n\uff08\u4f8b\uff1arootRecordName\u3092app\u3068\u3057\u305f\u5834\u5408\u3001\u4ee5\u4e0b\u306e\u3088\u3046\u306a\u30dc\u30bf\u30f3\u3092\u4f5c\u6210\u3059\u308b\u5834\u5408\u306b\u767a\u751f\uff09\n<div th:replace=\"~{bootstrap/components :: submitButton('app', ...)}\"></div>\n\ntext\u306a\u3069\u306e\u60c5\u5831\u306f\u3001GET\u3067\u3044\u3046\u3068\u3001request param\u306e\u4e2d\u3067\"app.desc=...\"\u306e\u3088\u3046\u306b\u8a18\u8f09\u3055\u308c\u308b\u304c\u3001\u305d\u306eparameter\u306e\u4e2d\u3067\nspring mvc\u3060\u3068\u30dc\u30bf\u30f3\u540d\u304c\"app=\"\u3068\u51fa\u308b\u3002\n\u3053\u306e\u30dc\u30bf\u30f3\u540d\u306b\u5bfe\u3059\u308b\"app=\"\u3092\u3001\"app\"\u306e\u30ad\u30fc\u30ef\u30fc\u30c9\u304c\u3042\u308b\u305f\u3081form\u3078\u306emapping\u5bfe\u8c61\u3060\u3068spring\u304c\u52d8\u9055\u3044\u3059\u308b\u305f\u3081\u306b\u3001\nmapping\u3092\u30c8\u30e9\u30a4\u3057\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u3066\u3044\u308b\u306e\u304b\u3082\u3002\n\uff08\u3061\u306a\u307f\u306b\u3001\u30dc\u30bf\u30f3\u306ename\u304cappzzz\u306a\u3069\u3001app\u304b\u3089\u59cb\u307e\u308b\u304capp\u3068\u306f\u7570\u306a\u308b\u6587\u5b57\u5217\u3067\u3042\u308c\u3070\u3001\u3053\u306e\u554f\u984c\u306f\u767a\u751f\u3057\u306a\u3044\uff09\n";
            throw new RuntimeException(msg);
        }
        return errorList.stream().map(b -> new ValidationAppException(b)).toList();
    }

    private void removeDuplicatedValidators(List<ConstraintViolationBean<?>> cvList) {
        HashMap duplicateCheckMap = new HashMap();
        HashSet<String> keySetWithNotEmpty = new HashSet<String>();
        for (ConstraintViolationBean<?> cv : cvList) {
            String key = cv.getFieldInfoBeans()[0].itemPropertyPathForForm.toString();
            if (duplicateCheckMap.get(key) == null) {
                duplicateCheckMap.put(key, new HashSet());
            }
            ((Set)duplicateCheckMap.get(key)).add(cv);
            if (!this.isNotEmptyValidator(cv)) continue;
            keySetWithNotEmpty.add(key);
        }
        for (String key : keySetWithNotEmpty) {
            for (ConstraintViolationBean cv : (Set)duplicateCheckMap.get(key)) {
                if (this.isNotEmptyValidator(cv)) continue;
                cvList.remove(cv);
            }
        }
    }

    private boolean isNotEmptyValidator(ConstraintViolationBean<?> cv) {
        String validatorClass = cv.getValidatorClass();
        return validatorClass.endsWith("NotEmpty") || validatorClass.endsWith("NotEmptyIfValid");
    }

    private Comparator<ConstraintViolationBean<?>> getComparator() {
        return new Comparator<ConstraintViolationBean<?>>(this){

            @Override
            public int compare(ConstraintViolationBean<?> f1, ConstraintViolationBean<?> f2) {
                int result = f1.getFieldInfoBeans()[0].itemPropertyPathForForm.toString().compareTo(f2.getFieldInfoBeans()[0].itemPropertyPathForForm.toString());
                if (result != 0) {
                    return result;
                }
                result = f1.getValidatorClass().compareTo(f2.getValidatorClass());
                if (result != 0) {
                    return result;
                }
                String s1 = (String)f1.getParamMap().get("regexp");
                String s2 = (String)f2.getParamMap().get("regexp");
                return s1.compareTo(s2);
            }
        };
    }

    public static class ControllerContext {
        private String[] functionKinds = new String[0];
        @Nonnull
        private String function;
        @Nonnull
        private String subFunction = "";
        @Nullable
        private String htmlFilenamePostfix;
        @Nullable
        private String mainRootRecordName;

        ControllerContext() {
        }

        public ControllerContext functionKinds(String ... functionKinds) {
            this.functionKinds = functionKinds;
            return this;
        }

        public String[] functionKinds() {
            return this.functionKinds;
        }

        @Nonnull
        public ControllerContext function(String function) {
            this.function = function == null ? "" : function;
            return this;
        }

        @Nonnull
        public String function() {
            return this.function;
        }

        @Nonnull
        public ControllerContext subFunction(@RequireNonnull String subFunction) {
            this.subFunction = (String)ObjectsUtil.requireNonNull((Object)subFunction);
            return this;
        }

        @Nonnull
        public String subFunction() {
            return this.subFunction;
        }

        @Nonnull
        public ControllerContext htmlFilenamePostfix(String htmlFilenamePostfix) {
            this.htmlFilenamePostfix = htmlFilenamePostfix;
            return this;
        }

        @Nullable
        public String htmlFilenamePostfix() {
            return this.htmlFilenamePostfix;
        }

        @Nonnull
        public ControllerContext mainRootRecordName(String rootRecordName) {
            this.mainRootRecordName = rootRecordName;
            return this;
        }

        @Nonnull
        public String mainRootRecordName() {
            return this.mainRootRecordName == null ? this.function : this.mainRootRecordName;
        }
    }
}

