/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.web.form.PagerInfo;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.item.HtmlItemContainer;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public abstract class SplibSearchForm
extends SplibGeneralForm {
    public static final String DIRECTION_ASC = "asc";
    public static final String DIRECTION_DESC = "desc";
    private boolean requestFromSearchForm;
    private Boolean newlyCreated;
    private boolean prepared = false;
    protected String sortItem = this.getDefaultSortItem();
    protected String direction = this.getDefaultDirection();
    protected Integer page = 0;
    protected Integer recordsInScreen = 5;
    protected Integer numberOfRecords;

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    @Nonnull
    protected abstract String getDefaultSortItem();

    protected String getDefaultDirection() {
        return DIRECTION_ASC;
    }

    public boolean isRequestFromSearchForm() {
        return this.requestFromSearchForm;
    }

    public void setRequestFromSearchForm(boolean requestFromSearchForm) {
        this.requestFromSearchForm = requestFromSearchForm;
    }

    public boolean getNewlyCreated() {
        return this.newlyCreated == null ? false : this.newlyCreated;
    }

    public Boolean getNewlyCreatedRawValue() {
        return this.newlyCreated;
    }

    public void setNewlyCreated(Boolean newlyCreated) {
        this.newlyCreated = newlyCreated;
    }

    public String getSortItem() {
        return this.sortItem;
    }

    @Nonnull
    public String getSortItemWithDefault() {
        String rtn = this.sortItem == null ? this.getDefaultSortItem() : this.sortItem;
        return Objects.requireNonNull(rtn);
    }

    public void setSortItem(String sortItem) {
        this.sortItem = sortItem;
    }

    public String getDirection() {
        return this.direction;
    }

    public Sort.Direction getDirectionEnum() {
        return this.direction != null && this.direction.equals(DIRECTION_DESC) ? Sort.Direction.DESC : Sort.Direction.ASC;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String nextDirection(String sortItem) {
        if (this.sortItem != null && this.sortItem.equals(sortItem) && this.getDirection().equals(DIRECTION_ASC)) {
            return DIRECTION_DESC;
        }
        return DIRECTION_ASC;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getRecordsInScreen() {
        return this.recordsInScreen;
    }

    public void setRecordsInScreen(Integer recordsInScreen) {
        this.recordsInScreen = recordsInScreen;
    }

    public Integer getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void setNumberOfRecordsAndAdjustCurrentPageNumger(Long numberOfRecords) {
        this.numberOfRecords = numberOfRecords.intValue();
        this.changePageIfThePageNumberExceedsTheLast();
    }

    private void changePageIfThePageNumberExceedsTheLast() {
        int lastPageFromRecordCount = this.numberOfRecords / this.recordsInScreen + (this.numberOfRecords % this.recordsInScreen > 0 ? 1 : 0) - 1;
        if (lastPageFromRecordCount < 0) {
            lastPageFromRecordCount = 0;
        }
        if (this.getPage() > lastPageFromRecordCount) {
            this.page = lastPageFromRecordCount;
        }
    }

    public PageRequest getPageRequest() {
        return PageRequest.of((int)this.getPage(), (int)this.getRecordsInScreen(), (Sort)Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(this.getDirectionEnum(), this.getSortItemWithDefault())}));
    }

    public List<PagerInfo> getPagerInfoList(Locale locale) {
        boolean needsSandwichedNumber;
        String labelPrev = PropertyFileUtil.getMessage((Locale)locale, (String)"jp.ecuacion.splib.web.common.label.prev", (String[])new String[0]);
        String labelNext = PropertyFileUtil.getMessage((Locale)locale, (String)"jp.ecuacion.splib.web.common.label.next", (String[])new String[0]);
        ArrayList<PagerInfo> rtnList = new ArrayList<PagerInfo>();
        PageRequest pageRequest = this.getPageRequest();
        if (this.numberOfRecords <= this.recordsInScreen) {
            return rtnList;
        }
        rtnList.add(pageRequest.getPageNumber() > 0 ? new PagerInfo(labelPrev, false, pageRequest.getPageNumber() - 1) : new PagerInfo(labelPrev));
        rtnList.add(new PagerInfo("1", pageRequest.getPageNumber() == 0, 0));
        if (pageRequest.getPageNumber() == 0 && this.numberOfRecords > this.recordsInScreen * 2 || pageRequest.getPageNumber() >= 2) {
            rtnList.add(new PagerInfo("..."));
        }
        int lastPageFromRecordCount = this.numberOfRecords / this.recordsInScreen + (this.numberOfRecords % this.recordsInScreen > 0 ? 1 : 0) - 1;
        boolean bl = needsSandwichedNumber = pageRequest.getPageNumber() != 0 && pageRequest.getPageNumber() < lastPageFromRecordCount;
        if (needsSandwichedNumber) {
            rtnList.add(new PagerInfo(Integer.toString(pageRequest.getPageNumber() + 1), true, pageRequest.getPageNumber()));
        }
        if (pageRequest.getPageNumber() <= lastPageFromRecordCount - 2 && needsSandwichedNumber) {
            rtnList.add(new PagerInfo("..."));
        }
        int lastPage = lastPageFromRecordCount > pageRequest.getPageNumber() ? lastPageFromRecordCount : pageRequest.getPageNumber();
        rtnList.add(new PagerInfo(Integer.toString(lastPage + 1), pageRequest.getPageNumber() == lastPage, lastPage));
        rtnList.add(pageRequest.getPageNumber() != lastPage ? new PagerInfo(labelNext, false, pageRequest.getPageNumber() + 1) : new PagerInfo(labelNext));
        return rtnList;
    }

    public String getLinesInScreen() {
        if (this.numberOfRecords == 0) {
            return "";
        }
        if (this.numberOfRecords / this.recordsInScreen < this.page) {
            return "( - / " + this.numberOfRecords + ")";
        }
        int min = this.page * this.recordsInScreen + 1;
        int normalMax = (this.page + 1) * this.recordsInScreen;
        int max = normalMax > this.numberOfRecords ? this.numberOfRecords : normalMax;
        return "( " + min + " - " + max + " / " + this.numberOfRecords + " )";
    }

    @Override
    protected List<String> getNotEmptyItemPropertyPathList(HtmlItemContainer rootRecord, String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return rootRecord.getNotEmptyOnSearchItemPropertyPathList(loginState, bean);
    }
}

