/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="optUtil")
public class SplibThymeleafOptionUtil {
    private DetailLogger detailLog = new DetailLogger((Object)this);

    private Map<String, List<String>> optionMap(String optionCsv, String duplicationCheckKey) {
        String[] options;
        HashMap<String, List<String>> rtnMap = new HashMap<String, List<String>>();
        if (optionCsv == null || optionCsv.equals("")) {
            return rtnMap;
        }
        String key = null;
        String value = null;
        for (String option : options = optionCsv.split(",")) {
            if (option.contains("=")) {
                key = StringUtils.trim((String)option.substring(0, option.indexOf("=")));
                value = StringUtils.trim((String)option.substring(option.indexOf("=") + 1));
            } else {
                key = option;
            }
            if (key.equals("")) continue;
            String lowerCaseKey = key.toLowerCase();
            if (!rtnMap.containsKey(lowerCaseKey)) {
                rtnMap.put(lowerCaseKey, new ArrayList());
            }
            if (((List)rtnMap.get(lowerCaseKey)).size() != 0 && duplicationCheckKey != null && duplicationCheckKey.toLowerCase().equals(lowerCaseKey)) {
                ((List)rtnMap.get(lowerCaseKey)).clear();
                this.detailLog.warn("html key is dupliicated in options. Duplicated key: " + key);
            }
            ((List)rtnMap.get(lowerCaseKey)).add(value);
        }
        return rtnMap;
    }

    private Map<String, List<String>> optionMap(String optionCsv) {
        return this.optionMap(optionCsv, null);
    }

    public boolean hasKey(String options, String key) {
        return this.optionMap(options).containsKey(key.toLowerCase());
    }

    public String getValue(String options, String key) {
        String lowerCaseKey = key.toLowerCase();
        Map<String, List<String>> map = this.optionMap(options, key);
        return map.containsKey(lowerCaseKey) ? map.get(lowerCaseKey).get(0) : null;
    }

    public String getValueOrElse(String options, String key, String defaultValue) {
        if (this.hasKey(options, key)) {
            return this.getValue(options, key);
        }
        return defaultValue;
    }

    public String[] getValues(String options, String key) {
        String lowerCaseKey = key.toLowerCase();
        Map<String, List<String>> map = this.optionMap(options);
        if (map.containsKey(lowerCaseKey)) {
            List<String> list = map.get(lowerCaseKey);
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    public String getValuesInSpaceSeparetedFormat(String options, String key) {
        return StringUtil.getSeparatedValuesString((String[])this.getValues(options, key), (String)" ");
    }

    private String getElementFromPsv(String option, int psvIndex) {
        if (StringUtils.isEmpty((CharSequence)option)) {
            return null;
        }
        if (option.split("\\|").length <= psvIndex) {
            return null;
        }
        String value = option.split("\\|")[psvIndex];
        return "null".equals(value) ? null : value;
    }

    public String getElementFromPsv(String options, String key, int psvIndex) {
        String option = this.getValue(options, key);
        return this.getElementFromPsv(option, psvIndex);
    }

    public String getElementFromPsvOrElse(String options, String key, int psvIndex, String defaultValue) {
        String element = this.getElementFromPsv(options, key, psvIndex);
        return element == null ? defaultValue : element;
    }

    public String getElementFromValuesOfPsv(String options, String key, int arrayIndex, int psvIndex) {
        String[] array = this.getValues(options, key);
        if (array.length <= arrayIndex) {
            return null;
        }
        return this.getElementFromPsv(array[arrayIndex], psvIndex);
    }

    public String getElementFromValuesOfPsvOrElse(String options, String key, int arrayIndex, int psvIndex, String defaultValue) {
        String element = this.getElementFromValuesOfPsv(options, key, arrayIndex, psvIndex);
        return element == null ? defaultValue : element;
    }
}

