/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MessagesBean {
    private boolean needsSuccessMessage = false;
    private WarnMessageBean warnMessage;
    private List<ErrorMessageBean> errorMessageList = new ArrayList<ErrorMessageBean>();

    public boolean getNeedsSuccessMessage() {
        return this.needsSuccessMessage;
    }

    public void setNeedsSuccessMessage(boolean needsSuccessMessage) {
        this.needsSuccessMessage = needsSuccessMessage;
    }

    public WarnMessageBean getWarnMessage() {
        return this.warnMessage;
    }

    public void setWarnMessage(WarnMessageBean warnMessage) {
        this.warnMessage = warnMessage;
    }

    public void setErrorMessage(String message, boolean isShownAtEachItem, String ... itemPropertyPaths) {
        this.errorMessageList.add(new ErrorMessageBean(message, isShownAtEachItem, itemPropertyPaths));
    }

    public List<String> getErrorMessages() {
        ArrayList<String> rtnList = new ArrayList<String>();
        for (ErrorMessageBean bean : this.errorMessageList) {
            rtnList.add(bean.getMessage());
        }
        return rtnList;
    }

    private String[] getErrorMessages(String itemPropertyPath) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (ErrorMessageBean bean : this.errorMessageList) {
            if (!bean.getItemPropertyPathSet().contains(itemPropertyPath)) continue;
            returnList.add(bean.message);
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    public List<String> getErrorMessagesAtEachItem() {
        return this.errorMessageList.stream().filter(e -> e.getIsShownAtEachItem() && e.getItemPropertyPathSet().size() > 0).map(e -> e.getMessage()).collect(Collectors.toList());
    }

    public List<String> getErrorMessagesAtEachItem(String itemPropertyPath) {
        return this.errorMessageList.stream().filter(e -> e.getIsShownAtEachItem() && e.getItemPropertyPathSet().size() > 0).filter(e -> e.getItemPropertyPathSet().contains(itemPropertyPath)).map(e -> e.getMessage()).collect(Collectors.toList());
    }

    public List<String> getErrorMessagesAtTheTop() {
        return this.errorMessageList.stream().filter(e -> !e.getIsShownAtEachItem() || e.getItemPropertyPathSet().size() <= 0).map(e -> e.getMessage()).collect(Collectors.toList());
    }

    public String isValid(String itemPropertyPath) {
        return this.getErrorMessages(itemPropertyPath).length > 0 ? "is-invalid" : "";
    }

    public static class WarnMessageBean {
        private String messageId;
        private String message;
        private String buttonName;

        public WarnMessageBean(String messageId, String message) {
            this(messageId, message, null);
        }

        public WarnMessageBean(String messageId, String message, String buttonName) {
            this.messageId = messageId;
            this.message = message;
            this.buttonName = buttonName;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getButtonName() {
            return this.buttonName == null ? "" : this.buttonName;
        }
    }

    static class ErrorMessageBean {
        private String message;
        private boolean isShownAtEachItem;
        private Set<String> itemPropertyPathSet = new HashSet<String>();

        public ErrorMessageBean(String message) {
            this.message = message;
        }

        public ErrorMessageBean(String message, boolean isShownAtEachItem, String ... itemPropertyPaths) {
            this.message = message;
            this.isShownAtEachItem = isShownAtEachItem;
            this.itemPropertyPathSet = new HashSet<String>(Arrays.asList(itemPropertyPaths == null ? new String[]{} : itemPropertyPaths).stream().map(itemPropertyPath -> StringUtils.uncapitalize((String)itemPropertyPath)).toList());
        }

        public String getMessage() {
            return this.message;
        }

        public boolean getIsShownAtEachItem() {
            return this.isShownAtEachItem;
        }

        public Set<String> getItemPropertyPathSet() {
            return this.itemPropertyPathSet;
        }
    }
}

