/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Base64;
import jp.ecuacion.lib.core.util.DateTimeApiUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class SplibComponentUtil {
    public static String saveUploadedFile(MultipartFile file) throws Exception {
        if (file == null) {
            return null;
        }
        return SplibComponentUtil.saveUploadedFileCommon(file.getBytes(), file.getName());
    }

    public static String saveUploadedFile(String base64) throws Exception {
        if (StringUtils.isEmpty((CharSequence)base64)) {
            return null;
        }
        String part = ";base64,";
        base64 = base64.substring(base64.indexOf(part) + part.length());
        Base64.Decoder decoder = Base64.getDecoder();
        return SplibComponentUtil.saveUploadedFileCommon(decoder.decode(base64), "");
    }

    private static String saveUploadedFileCommon(byte[] bytes, String filename) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        String workDirPath = PropertyFileUtil.getApplication((String)"jp.ecuacion.work-dir");
        new File(workDirPath).mkdirs();
        String tmpFilename = DateTimeApiUtil.getTimestampStringForFilename((LocalDateTime)LocalDateTime.now()) + "-" + Thread.currentThread().threadId() + "-" + filename;
        String tmpFilePath = workDirPath + "/" + tmpFilename;
        try (FileOutputStream output = new FileOutputStream(tmpFilePath);){
            output.write(bytes);
        }
        return tmpFilePath;
    }

    public static String getPictureDataBase64(String path, String pictureFormat) throws Exception {
        Base64.Encoder encoder = Base64.getEncoder();
        return "data:image/" + pictureFormat + ";base64," + encoder.encodeToString(Files.readAllBytes(Path.of(path, new String[0])));
    }
}

