/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.advice;

import jp.ecuacion.splib.core.record.SplibRecord;
import jp.ecuacion.splib.web.service.SplibDataStoreDependentControllerAdviceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class SplibDataStoreDependentControllerAdvice {
    @Autowired
    SplibDataStoreDependentControllerAdviceService service;

    @ModelAttribute
    protected void setAccountInfo(Model model, @AuthenticationPrincipal UserDetails loginUser) {
        this.executeForAll();
        if (loginUser == null) {
            return;
        }
        SplibRecord loginAcc = null;
        boolean isAdmin = loginUser.getAuthorities().stream().map(e -> e.getAuthority()).filter(auth -> auth.startsWith("ROLE_ADMIN")).toList().size() > 0;
        SplibRecord splibRecord = loginAcc = isAdmin ? this.service.getAccAdmin(loginUser) : this.service.getAccGeneral(loginUser);
        if (!isAdmin) {
            this.executeForAccountBelongingToGroup(loginAcc);
        }
        model.addAttribute("loginAcc", (Object)loginAcc);
    }

    protected void executeForAll() {
    }

    protected void executeForAccountBelongingToGroup(SplibRecord acc) {
    }
}

