/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.exception;

import java.util.Locale;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import org.slf4j.event.Level;

public class RedirectException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String redirectPath;
    private String messageId;
    private String[] messageArgs;
    private Level logLevel;
    private String logString;

    public RedirectException(String redirectPath) {
        this.redirectPath = redirectPath;
    }

    public RedirectException(String redirectPath, String messageId, String ... messageArgs) {
        this.redirectPath = redirectPath;
        this.messageId = messageId;
        this.messageArgs = messageArgs;
    }

    public RedirectException(String redirectPath, Level logLevel, String logString) {
        this.redirectPath = redirectPath;
        this.logLevel = logLevel;
        this.logString = logString;
    }

    public RedirectException(String redirectPath, Level logLevel, String logString, String messageId, String ... messageArgs) {
        this.redirectPath = redirectPath;
        this.logLevel = logLevel;
        this.logString = logString;
        this.messageId = messageId;
        this.messageArgs = messageArgs;
    }

    public RedirectException(String redirectPath, Level logLevel, String messageId, String[] messageArgs) {
        this.redirectPath = redirectPath;
        this.logLevel = logLevel;
        this.logString = PropertyFileUtil.getMessage((Locale)Locale.ENGLISH, (String)messageId, (String[])messageArgs);
        this.messageId = messageId;
        this.messageArgs = messageArgs;
    }

    public String getRedirectPath() {
        return this.redirectPath;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String[] getMessageArgs() {
        return this.messageArgs;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public String getLogString() {
        return this.logString;
    }
}

