/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.exceptionhandler;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.AppWarningException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import jp.ecuacion.splib.web.bean.MessagesBean;
import jp.ecuacion.splib.web.bean.ReturnUrlBean;
import jp.ecuacion.splib.web.controller.SplibEditController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.exception.RedirectException;
import jp.ecuacion.splib.web.exception.RedirectToHomePageException;
import jp.ecuacion.splib.web.exception.WebAppWarningException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibExceptionHandler {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    @Autowired
    HttpServletRequest request;
    @Autowired(required=false)
    SplibExceptionHandlerAction actionOnThrowable;
    @Autowired
    private SplibUtil util;

    @Nonnull
    protected SplibGeneralController<?> getController() {
        return (SplibGeneralController)this.getModel().getAttribute("controller");
    }

    @Nonnull
    private SplibGeneralForm[] getForms() {
        return (SplibGeneralForm[])this.getModel().getAttribute("forms");
    }

    @Nonnull
    private Model getModel() {
        return (Model)this.request.getAttribute("model");
    }

    @Nonnull
    private ModelAndView appExceptionFinalHandler(@Nonnull SplibGeneralController<?> ctrl, @Nullable UserDetails loginUser, boolean isRedirect, @Nullable ReturnUrlBean redirectBean) {
        SplibGeneralForm[] forms = (SplibGeneralForm[])this.getModel().getAttribute("forms");
        ((SplibGeneralService)this.getController().getService()).prepareForm(Arrays.asList(forms), loginUser);
        if (redirectBean == null) {
            redirectBean = new ReturnUrlBean(ctrl, this.util, false);
        }
        if (!isRedirect) {
            return new ModelAndView(ctrl.getDefaultHtmlPageName(), this.getModel().asMap());
        }
        String path = this.util.prepareForPageTransition(this.request, redirectBean, this.getModel(), true);
        return new ModelAndView(path);
    }

    @ExceptionHandler(value={AppWarningException.class})
    @Nonnull
    public ModelAndView handleAppWarningException(@Nonnull WebAppWarningException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        MessagesBean messagesBean = (MessagesBean)this.getModel().getAttribute("messagesBean");
        Objects.requireNonNull(messagesBean);
        messagesBean.setWarnMessage(new MessagesBean.WarnMessageBean(exception.getMessageId(), PropertyFileUtil.getMessage((Locale)this.request.getLocale(), (String)exception.getMessageId(), (String[])exception.getMessageArgs()), exception.buttonIdToPressOnConfirm()));
        return this.appExceptionFinalHandler(this.getController(), loginUser, false, null);
    }

    @ExceptionHandler(value={AppException.class})
    @Nonnull
    public ModelAndView handleAppException(@Nonnull AppException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        ArrayList<SingleAppException> exList = new ArrayList<SingleAppException>();
        if (exception instanceof MultipleAppException) {
            for (SingleAppException appEx : ((MultipleAppException)exception).getList()) {
                exList.add(appEx);
            }
            if (exList.size() == 0) {
                throw new RuntimeException("No exception included in MultipleAppException.");
            }
        } else {
            exList.add((SingleAppException)exception);
        }
        MessageSetter msgSetter = new MessageSetter();
        MessagesBean messagesBean = (MessagesBean)this.getModel().getAttribute("messagesBean");
        boolean hasDesignatedItemPropertyPathInBizLogicAppException = false;
        for (SingleAppException saex : exList) {
            String[] paths;
            ArrayList<Object> recordPropertyPathList = new ArrayList<Object>();
            for (String itemPropertyPath : saex.getItemPropertyPaths()) {
                if (!itemPropertyPath.startsWith(this.getController().getRootRecordName() + ".")) {
                    recordPropertyPathList.add(this.getController().getRootRecordName() + "." + itemPropertyPath);
                    continue;
                }
                recordPropertyPathList.add(itemPropertyPath);
            }
            String[] recordPropertyPaths = recordPropertyPathList.toArray(new String[recordPropertyPathList.size()]);
            msgSetter.setMessage(messagesBean, saex, this.request.getLocale(), recordPropertyPaths);
            if (!(saex instanceof BizLogicAppException) || (paths = ((BizLogicAppException)saex).getItemPropertyPaths()) == null || paths.length <= 0) continue;
            hasDesignatedItemPropertyPathInBizLogicAppException = true;
        }
        msgSetter.addMessageThatSaysThereIsAnError(messagesBean, this.request.getLocale(), hasDesignatedItemPropertyPathInBizLogicAppException);
        ReturnUrlBean redirectBean = this.getController().getRedirectUrlOnAppExceptionBean();
        return this.appExceptionFinalHandler(this.getController(), loginUser, true, redirectBean);
    }

    @ExceptionHandler(value={UncheckedAppException.class})
    @Nonnull
    public ModelAndView handleUncheckedAppException(@Nonnull UncheckedAppException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.handleAppException((AppException)exception.getCause(), loginUser);
    }

    @ExceptionHandler(value={OverlappingFileLockException.class})
    @Nonnull
    public ModelAndView handleOptimisticLockingFailureException(@Nonnull OverlappingFileLockException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser, Model model) throws Exception {
        String msgId = "jp.ecuacion.splib.web.common.message.optimisticLocking";
        if (this.getController() instanceof SplibEditController) {
            String loginState = (String)this.getModel().getAttribute("loginState");
            String path = "/" + loginState + "/" + this.getController().getFunction() + "/" + this.getController().getDefaultDestSubFunctionOnNormalEnd() + "/" + this.getController().getDefaultDestPageOnNormalEnd();
            return this.handleRedirectNeededExceptions(new RedirectException(path, msgId, new String[0]), model);
        }
        return this.handleAppException((AppException)new BizLogicAppException(msgId, new String[0]), loginUser);
    }

    @ExceptionHandler(value={NoResourceFoundException.class, RedirectException.class})
    @Nonnull
    public ModelAndView handleRedirectNeededExceptions(@RequireNonnull Exception exception, Model newModel) {
        RedirectException redirectException = null;
        Model model = this.getModel();
        if (model == null) {
            model = newModel;
            newModel.addAttribute("messagesBean", (Object)new MessagesBean());
        }
        if (!StringUtils.isEmpty((CharSequence)exception.getMessage())) {
            this.detailLog.info(exception.getMessage());
        }
        if (exception instanceof NoResourceFoundException) {
            String path = ((NoResourceFoundException)exception).getResourcePath();
            redirectException = new RedirectToHomePageException("jp.ecuacion.splib.web.common.message.NoResourceFoundException", path);
        } else {
            redirectException = (RedirectException)exception;
        }
        if (redirectException.getLogLevel() != null) {
            this.detailLog.log(redirectException.getLogLevel(), redirectException.getLogString());
        }
        if (!StringUtils.isEmpty((CharSequence)redirectException.getMessageId())) {
            MessagesBean messagesBean = (MessagesBean)model.getAttribute("messagesBean");
            BizLogicAppException blaex = new BizLogicAppException(redirectException.getMessageId(), redirectException.getMessageArgs());
            new MessageSetter().setMessage(messagesBean, (SingleAppException)blaex, this.request.getLocale(), new String[0]);
        }
        ReturnUrlBean redirectBean = new ReturnUrlBean(redirectException.getRedirectPath());
        String path = this.util.prepareForPageTransition(this.request, redirectBean, model, true);
        return new ModelAndView(path);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ModelAndView handleThrowable(@Nonnull Throwable exception, @Nonnull Model model) {
        LogUtil.logSystemError((DetailLogger)this.detailLog, (Throwable)exception);
        if (this.actionOnThrowable != null) {
            this.actionOnThrowable.execute(exception);
        }
        Model mdl = this.getModel() == null ? model : this.getModel();
        return new ModelAndView("error", mdl.asMap(), HttpStatusCode.valueOf((int)500));
    }

    private static class MessageSetter {
        private static boolean needsMsgAtItem = Boolean.valueOf(PropertyFileUtil.getApplicationOrElse((String)"jp.ecuacion.splib.web.process-result-message.shown-at-each-item", (String)"false"));
        private static boolean needsMsgAtTop = Boolean.valueOf(PropertyFileUtil.getApplicationOrElse((String)"jp.ecuacion.splib.web.process-result-message.shown-at-the-top", (String)"false"));

        private MessageSetter() {
        }

        public void setMessage(MessagesBean messagesBean, SingleAppException saex, Locale locale, String ... recordPropertyPaths) {
            if (!needsMsgAtItem && !needsMsgAtTop) {
                String msg = "One of 'jp.ecuacion.splib.web.process-result-message.shown-at-each-item' or 'jp.ecuacion.splib.web.process-result-message.shown-at-the-top' must be true.";
                throw new EclibRuntimeException(msg);
            }
            String messageAtItem = null;
            String messageAtTop = null;
            if (needsMsgAtItem) {
                messageAtItem = (String)ExceptionUtil.getAppExceptionMessageList((AppException)saex, (Locale)locale, (boolean)false).get(0);
                messagesBean.setErrorMessage(messageAtItem, recordPropertyPaths.length != 0, recordPropertyPaths);
            }
            if (needsMsgAtTop) {
                messageAtTop = (String)ExceptionUtil.getAppExceptionMessageList((AppException)saex, (Locale)locale, (boolean)true).get(0);
                if (!needsMsgAtItem || recordPropertyPaths.length != 0) {
                    messagesBean.setErrorMessage(messageAtTop, false, recordPropertyPaths);
                }
            }
        }

        public void addMessageThatSaysThereIsAnError(MessagesBean messagesBean, Locale locale, boolean hasDesignatedItemPropertyPathInBizLogicAppException) {
            if (needsMsgAtItem && !needsMsgAtTop && hasDesignatedItemPropertyPathInBizLogicAppException) {
                String key = "jp.ecuacion.splib.web.common.message.messagesLinkedToItemsExist";
                messagesBean.setErrorMessage(PropertyFileUtil.getMessage((Locale)locale, (String)key, (String[])new String[0]), false, new String[0]);
            }
        }
    }
}

