/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.bean.MessagesBean;
import jp.ecuacion.splib.web.bean.ReturnUrlBean;
import jp.ecuacion.splib.web.controller.SplibGeneral1FormController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibEditService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibEditController<F extends SplibEditForm, S extends SplibEditService<F>>
extends SplibGeneral1FormController<F, S> {
    private static final String PARAM_INSERT = "showInsertForm";
    private static final String PARAM_UPDATE = "showUpdateForm";
    private PageTemplatePatternEnum pageTemplatePattern;
    protected ReturnUrlBean redirectOnSuccess;
    @Autowired
    private SplibUtil util;

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String function) {
        this(pageTemplatePattern, function, new SplibGeneralController.ControllerContext());
    }

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String function, SplibGeneralController.ControllerContext settings) {
        super(function, settings.subFunction("edit"));
        this.pageTemplatePattern = pageTemplatePattern;
    }

    @Override
    public String getDefaultDestSubFunctionOnNormalEnd() {
        return this.pageTemplatePattern == PageTemplatePatternEnum.SINGLE ? "edit" : "searchList";
    }

    @Override
    public String page(Model model, F form, @AuthenticationPrincipal UserDetails loginUser) {
        throw new RuntimeException("\"page\" needs params.");
    }

    @GetMapping(value={"page"}, params={"showInsertForm"})
    public String showInsertPage(Model model, F form, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.pageCommon(model, form, loginUser, true);
    }

    @GetMapping(value={"page"}, params={"showUpdateForm"})
    public String showUpdatePage(Model model, F form, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.pageCommon(model, form, loginUser, false);
    }

    private String pageCommon(Model model, F form, UserDetails loginUser, boolean isInsert) throws Exception {
        this.prepare(model, loginUser, new SplibGeneralForm[]{form});
        MessagesBean messageBean = (MessagesBean)model.getAttribute("messagesBean");
        if (messageBean.getErrorMessages().size() == 0) {
            ((SplibEditForm)form).setIsInsert(isInsert);
            ((SplibEditService)this.getService()).page(form, loginUser);
        }
        ((SplibEditService)this.getService()).prepareForm(form, loginUser);
        return this.getDefaultHtmlPageName();
    }

    @PostMapping(value={"action"}, params={"insertOrUpdate"})
    public String edit(@Validated F form, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.addParamToParamListOnRedirectToSelf(((SplibEditForm)form).isInsert() != false ? PARAM_INSERT : PARAM_UPDATE);
        this.prepare(model, loginUser, ((SplibGeneralForm)form).validate(result));
        ((SplibEditService)this.getService()).edit(form, loginUser);
        ReturnUrlBean redirectBean = this.redirectOnSuccess == null ? new ReturnUrlBean(this, this.util, true).showSuccessMessage() : this.redirectOnSuccess;
        redirectBean.putParam("dataKind", ((SplibGeneralForm)form).getDataKind());
        redirectBean.putParam(PARAM_UPDATE, ((SplibGeneralForm)form).getDataKind());
        return redirectBean.getUrl();
    }

    @PostMapping(value={"action"}, params={"back"})
    public String back(@Validated F editForm, BindingResult result, Model model) {
        boolean isSingle = this.pageTemplatePattern == PageTemplatePatternEnum.SINGLE;
        String retunPageFunction = isSingle ? "edit" : "searchList";
        ReturnUrlBean rtnBean = new ReturnUrlBean(this, this.util, retunPageFunction, "page").putParam("dataKind", ((SplibGeneralForm)editForm).getDataKind());
        if (isSingle) {
            rtnBean.putParam(PARAM_UPDATE, (String)null);
        }
        return rtnBean.getUrl();
    }

    public static enum PageTemplatePatternEnum {
        SINGLE,
        PAIR_WITH_SEARCH_LIST;

    }
}

