/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.config;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class SplibWebSecurityConfigForSwitchUser {
    @Autowired
    UserDetailsService userDetailsService;

    protected abstract String getSwitchingUserDonePagePath();

    protected abstract String getSwitchingUserFailurePagePath();

    protected abstract String getExitingUserDonePagePath();

    @Bean
    SwitchUserFilter switchUserFilter() {
        SwitchUserFilter filter = new SwitchUserFilter();
        filter.setUserDetailsService(this.userDetailsService);
        filter.setUsernameParameter("adminLogin.username");
        filter.setSwitchUserMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, "/admin/switchUser"));
        filter.setExitUserMatcher((RequestMatcher)PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, "/account/exitUser"));
        filter.setSuccessHandler((AuthenticationSuccessHandler)new CustomLoginSuccessHandler(this.getSwitchingUserDonePagePath(), this.getExitingUserDonePagePath()));
        filter.setFailureHandler((AuthenticationFailureHandler)new CustomLoginFailureHandler(this.getSwitchingUserFailurePagePath()));
        return filter;
    }

    private static class CustomLoginSuccessHandler
    implements AuthenticationSuccessHandler {
        private String switchingUserDonePagePath;
        private String exitingUserDonePagePath;

        public CustomLoginSuccessHandler(String switchingUserDonePagePath, String exitingUserDonePagePath) {
            this.switchingUserDonePagePath = switchingUserDonePagePath;
            this.exitingUserDonePagePath = exitingUserDonePagePath;
        }

        public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
            if (request.getRequestURI().endsWith("/admin/switchUser")) {
                response.sendRedirect(request.getContextPath() + this.switchingUserDonePagePath);
            } else {
                response.sendRedirect(request.getContextPath() + this.exitingUserDonePagePath);
            }
        }
    }

    private static class CustomLoginFailureHandler
    implements AuthenticationFailureHandler {
        private String exitingUserDonePagePath;

        public CustomLoginFailureHandler(String exitingUserDonePagePath) {
            this.exitingUserDonePagePath = exitingUserDonePagePath;
        }

        public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
            response.sendRedirect(request.getContextPath() + this.exitingUserDonePagePath);
        }
    }
}

