/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.util.SplibUtil;

public class ReturnUrlBean {
    private boolean isForward = false;
    @Nonnull
    private String path;
    @Nonnull
    private final Map<String, String[]> paramMap = new HashMap<String, String[]>();

    public ReturnUrlBean(@RequireNonnull SplibGeneralController<?> controller, @RequireNonnull SplibUtil util) {
        this(controller, util, true);
    }

    public ReturnUrlBean(@RequireNonnull SplibGeneralController<?> controller, @RequireNonnull SplibUtil util, boolean isNormalEnd) {
        this((SplibGeneralController)ObjectsUtil.requireNonNull(controller), util, isNormalEnd, isNormalEnd ? controller.getDefaultDestPageOnNormalEnd() : controller.getDefaultDestPageOnAbnormalEnd());
    }

    public ReturnUrlBean(@RequireNonnull SplibGeneralController<?> controller, @RequireNonnull SplibUtil util, @RequireNonnull String page) {
        this(controller, util, true, page);
    }

    public ReturnUrlBean(@RequireNonnull SplibGeneralController<?> controller, @RequireNonnull SplibUtil util, boolean isNormalEnd, @RequireNonnull String page) {
        this((SplibGeneralController)ObjectsUtil.requireNonNull(controller), util, isNormalEnd ? controller.getDefaultDestSubFunctionOnNormalEnd() : controller.getDefaultDestSubFunctionOnAbnormalEnd(), page);
    }

    public ReturnUrlBean(@RequireNonnull SplibGeneralController<?> controller, @RequireNonnull SplibUtil util, @RequireNonnull String subFunction, @RequireNonnull String page) {
        this.path = this.getPathFromParams((SplibGeneralController)ObjectsUtil.requireNonNull(controller), ((SplibUtil)ObjectsUtil.requireNonNull((Object)util)).getLoginState(), (String)ObjectsUtil.requireNonNull((Object)subFunction), (String)ObjectsUtil.requireNonNull((Object)page));
        this.putParamList(controller.getParamListOnRedirectToSelf());
    }

    public ReturnUrlBean(@RequireNonnull String path) {
        this.path = (String)ObjectsUtil.requireNonNull((Object)path);
    }

    public String getUrl() {
        return this.getProtocol() + ":" + this.path + this.getParamsString();
    }

    public boolean isForward() {
        return this.isForward;
    }

    public ReturnUrlBean setProtocolForward() {
        this.isForward = true;
        this.putParam("forwarded", (String)null);
        return this;
    }

    private String getProtocol() {
        return this.isForward ? "forward" : "redirect";
    }

    private String getPathFromParams(SplibGeneralController<?> ctrl, String loginState, String subFunction, String page) {
        String functionKindPath = ctrl.getFunctionKinds().length == 0 ? "" : StringUtil.getSeparatedValuesString((String[])ctrl.getFunctionKinds(), (String)"/") + "/";
        Object subFuncPart = subFunction.equals("") ? "" : "/" + subFunction;
        return "/" + loginState + "/" + functionKindPath + ctrl.getFunction() + (String)subFuncPart + "/" + page;
    }

    private String getParamsString() {
        this.removeParam("transactionToken");
        if (this.isForward) {
            this.putParam("forward", "true");
        }
        boolean is1st = true;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.paramMap.entrySet()) {
            for (String value : entry.getValue()) {
                if (is1st) {
                    is1st = false;
                    sb.append(this.path.contains("?") ? "&" : "?");
                } else {
                    sb.append("&");
                }
                sb.append(entry.getKey() + "=" + value);
            }
        }
        return sb.toString();
    }

    public ReturnUrlBean putParam(String key, String value) {
        String[] stringArray;
        Objects.requireNonNull(key);
        if (value == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = value;
        }
        this.paramMap.put(key, stringArray);
        return this;
    }

    public ReturnUrlBean putParam(String key, String[] values) {
        String[] stringArray;
        Objects.requireNonNull(key);
        if (values == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = values;
        }
        this.paramMap.put(key, stringArray);
        return this;
    }

    public ReturnUrlBean putParamMap(Map<String, String[]> paramMap) {
        Objects.requireNonNull(paramMap);
        this.paramMap.putAll(paramMap);
        return this;
    }

    private void putParamList(List<String[]> keyValueList) {
        for (String[] keyValue : keyValueList) {
            this.putParam(keyValue[0], keyValue[1]);
        }
    }

    public ReturnUrlBean removeParam(String key) {
        this.paramMap.remove(key);
        return this;
    }

    public ReturnUrlBean showSuccessMessage() {
        this.putParam("success", new String[]{""});
        return this;
    }
}

