/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.ecuacion.splib.web.bean.HtmlItem;
import jp.ecuacion.splib.web.bean.HtmlItemNumber;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public interface RecordInterface {
    public HtmlItem[] getHtmlItems();

    default public boolean needsCommas(String itemId) {
        HtmlItem item = Arrays.asList(this.getHtmlItems()).stream().collect(Collectors.toMap(e -> e.getItemIdField(), e -> e)).get(itemId);
        if (item == null || !(item instanceof HtmlItemNumber)) {
            return false;
        }
        HtmlItemNumber numItem = (HtmlItemNumber)item;
        return numItem.getNeedsCommas();
    }

    default public String getDisplayName(String rootRecordId, String fieldId) {
        Map<String, String> displayNameIdMap;
        String displayNameId;
        HtmlItem[] htmlItems;
        HtmlItem[] htmlItemArray = htmlItems = this.getHtmlItems() == null ? new HtmlItem[]{} : this.getHtmlItems();
        if (fieldId.startsWith(rootRecordId + ".")) {
            fieldId = fieldId.substring((rootRecordId + ".").length());
        }
        displayNameId = (displayNameId = (displayNameIdMap = Arrays.asList(htmlItems).stream().collect(Collectors.toMap(e -> e.getItemIdField(), e -> e.getItemIdFieldForName() == null ? e.getItemIdField() : e.getItemIdFieldForName()))).get(fieldId)) == null ? fieldId : displayNameId;
        return displayNameId.contains(".") ? displayNameId : rootRecordId + "." + displayNameId;
    }

    default public HtmlItem[] mergeHtmlItems(HtmlItem[] fields1, HtmlItem[] fields2) {
        ArrayList<HtmlItem> list = new ArrayList<HtmlItem>(Arrays.asList(fields1));
        List<String> field1IdList = Arrays.asList(fields1).stream().map(e -> e.getItemIdField()).toList();
        for (String field2Id : Arrays.asList(fields2).stream().map(e -> e.getItemIdField()).toList()) {
            if (!field1IdList.contains(field2Id)) continue;
            throw new RuntimeException("'id' of HtmlItem[] duplicated with commonHtmlItems. key: " + field2Id);
        }
        list.addAll(Arrays.asList(fields2));
        return list.toArray(new HtmlItem[list.size()]);
    }

    default public List<String> getNotEmptyFields(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        HtmlItem[] htmlItems;
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlItem field : htmlItems = this.getHtmlItems()) {
            if (!field.getIsNotEmpty(loginState, bean)) continue;
            list.add(field.getItemIdField());
        }
        return list;
    }

    default public boolean isNotEmpty(String fieldId, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getNotEmptyFields(loginState, bean).contains(fieldId);
    }
}

