/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.splib.web.exception.RedirectToHomePageException;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/public/error"})
public class SplibErrorController
implements ErrorController {
    private DetailLogger detailLogger = new DetailLogger((Object)this);

    @RequestMapping(produces={"text/html"}, method={RequestMethod.POST, RequestMethod.GET})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response, Model model) {
        model.addAllAttributes(((Model)request.getAttribute("model")).asMap());
        Integer statusCode = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
        Exception exception = (Exception)request.getAttribute("jakarta.servlet.error.exception");
        if (statusCode == 404) {
            this.detailLogger.info("http status = 404. you can find the accessed url from the logs above. (Only when the DEBUG log of 'org.springframework.security.web.FilterChainProxy' is out)");
            return new ModelAndView("error/404", model.asMap(), (HttpStatusCode)HttpStatus.valueOf((int)statusCode));
        }
        if (exception != null) {
            LogUtil.logSystemError((DetailLogger)new DetailLogger((Object)this), (Throwable)exception);
        } else {
            this.detailLogger.info("SplibErrorController#errorHtml called. httpStatus = " + statusCode);
        }
        return new ModelAndView("error", model.asMap(), (HttpStatusCode)HttpStatus.valueOf((int)statusCode));
    }

    @GetMapping(value={"action"})
    public String action() throws RedirectToHomePageException {
        throw new RedirectToHomePageException();
    }
}

