/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.PropertyEditor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public abstract class SplibBaseController {
    @Autowired
    protected HttpServletRequest request;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
        binder.registerCustomEditor(Boolean.class, (PropertyEditor)((Object)new NullSupportCustomBooleanEditor()));
    }

    static class NullSupportCustomBooleanEditor
    extends CustomBooleanEditor {
        public NullSupportCustomBooleanEditor() {
            super(false);
        }

        public void setAsText(@Nullable String text) throws IllegalArgumentException {
            if (text == null || text.equals("null")) {
                this.setValue(false);
            } else if (text.equals("")) {
                this.setValue(null);
            } else if (text.contains(",")) {
                String[] arr = text.split(",");
                super.setAsText(arr[arr.length - 1]);
            } else {
                super.setAsText(text);
            }
        }
    }
}

