/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.StringUtil;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoggingInterceptor
implements HandlerInterceptor {
    private final DetailLogger detailLog = new DetailLogger((Object)this);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        List<String> paramList = request.getParameterMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + StringUtil.getCsv((String[])((String[])e.getValue()))).toList();
        this.detailLog.debug(this.getPrefix(request) + "request process started. request: " + request.getRequestURI() + (String)(paramList.size() == 0 ? "" : ", parameters: " + StringUtil.getSeparatedValuesString(paramList, (String)"&")));
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        this.detailLog.debug(this.getPrefix(request) + "request process finished.");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.detailLog.debug(this.getPrefix(request) + "view rendering finished.");
    }

    private String getPrefix(HttpServletRequest request) {
        return "session ID: " + request.getSession().getId() + ", thread ID: " + Thread.currentThread().threadId() + " : ";
    }
}

