/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.jakartavalidation.bean.ConstraintViolationBean;
import jp.ecuacion.splib.core.record.SplibRecord;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.item.HtmlItemContainer;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import org.springframework.validation.BindingResult;

public abstract class SplibGeneralForm {
    private PrepareSettings prepareSettings = new PrepareSettings();
    protected String dataKind;
    protected String confirmedWarnings;
    private SplibGeneralController.ControllerContext controllerContext;

    public PrepareSettings getPrepareSettings() {
        return this.prepareSettings;
    }

    public SplibGeneralForm validate(BindingResult bindingResult) {
        this.prepareSettings.validates = true;
        this.prepareSettings.bindingResult = bindingResult;
        return this;
    }

    public SplibGeneralForm noValidate() {
        this.prepareSettings.validates = false;
        return this;
    }

    public String getDataKind() {
        return this.dataKind;
    }

    public void setDataKind(String dataKind) {
        this.dataKind = dataKind;
    }

    public SplibGeneralController.ControllerContext getControllerContext() {
        return this.controllerContext;
    }

    public void setControllerContext(SplibGeneralController.ControllerContext controllerContext) {
        this.controllerContext = controllerContext;
    }

    public SplibRecord get(String itemName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        return (SplibRecord)this.getClass().getField(itemName).get(this);
    }

    public List<Field> getRootRecordFields() {
        Class<?> formCls = this.getClass();
        ArrayList<Field> checkList = new ArrayList<Field>();
        while (true) {
            Field[] fields;
            for (Field field : fields = formCls.getDeclaredFields()) {
                if (!SplibRecord.class.isAssignableFrom(field.getType())) continue;
                checkList.add(field);
            }
            if (formCls.getSuperclass() == SplibGeneralForm.class) {
                return checkList;
            }
            formCls = formCls.getSuperclass();
        }
    }

    public Object getRootRecord(String recordName) {
        Field field = this.getRootRecordFields().stream().collect(Collectors.toMap(f -> f.getName(), f -> f)).get(recordName);
        return this.getRootRecord(field);
    }

    protected Object getRootRecord(Field rootRecordField) {
        rootRecordField.setAccessible(true);
        Object rootRecord = null;
        try {
            rootRecord = rootRecordField.get(this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return rootRecord;
    }

    public String getConfirmedWarnings() {
        return this.confirmedWarnings;
    }

    public boolean containsConfirmedWarning(String messageId) {
        return this.getConfirmedWarningMessageSet().size() > 0;
    }

    public Set<String> getConfirmedWarningMessageSet() {
        HashSet<String> rtnSet = new HashSet<String>();
        if (this.confirmedWarnings == null || this.confirmedWarnings.equals("")) {
            return rtnSet;
        }
        rtnSet.addAll(Arrays.asList(this.confirmedWarnings.split(",")));
        return rtnSet;
    }

    public void setConfirmedWarnings(String confirmedWarnings) {
        this.confirmedWarnings = confirmedWarnings;
    }

    public boolean hasNotEmptyError(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.validateNotEmpty(loginState, bean).size() > 0;
    }

    public Set<ConstraintViolationBean> validateNotEmpty(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.validateNotEmpty(Locale.getDefault(), loginState, bean);
    }

    public Set<ConstraintViolationBean> validateNotEmpty(Locale locale, String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        String validationClass = "jakarta.validation.constraints.NotEmpty";
        HashSet<ConstraintViolationBean> rtnSet = new HashSet<ConstraintViolationBean>();
        List<Field> rootRecordFieldList = this.getRootRecordFields();
        for (Field rootRecordField : rootRecordFieldList) {
            String rootRecordName = rootRecordField.getName();
            HtmlItemContainer rootRecord = (HtmlItemContainer)this.getRootRecord(rootRecordField);
            for (String notEmptyItemPropertyPath : this.getNotEmptyItemPropertyPathList(rootRecord, loginState, bean)) {
                Object value = ((SplibRecord)rootRecord).getValue(notEmptyItemPropertyPath);
                if (value != null && (!(value instanceof String) || !((String)value).equals(""))) continue;
                rtnSet.add(new ConstraintViolationBean((Object)this, "jakarta.validation.constraints.NotEmpty.message", "jakarta.validation.constraints.NotEmpty", rootRecordName, notEmptyItemPropertyPath));
            }
        }
        return rtnSet;
    }

    protected List<String> getNotEmptyItemPropertyPathList(HtmlItemContainer rootRecord, String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return rootRecord.getNotEmptyItemPropertyPathList(loginState, bean);
    }

    public static class PrepareSettings {
        private boolean validates = false;
        private BindingResult bindingResult;

        public boolean validates() {
            return this.validates;
        }

        public BindingResult bindingResult() {
            return this.bindingResult;
        }
    }
}

