/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jp.ecuacion.lib.core.logging.DetailLogger;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoggingInterceptor
implements HandlerInterceptor {
    private final DetailLogger detailLog = new DetailLogger((Object)this);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.detailLog.debug("session ID: " + request.getSession().getId() + ", thread ID: " + Thread.currentThread().threadId() + " : request process started. request: " + request.getRequestURI());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        this.detailLog.debug("session ID: " + request.getSession().getId() + ", thread ID: " + Thread.currentThread().threadId() + " : request process finished.");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.detailLog.debug("session ID: " + request.getSession().getId() + ", thread ID: " + Thread.currentThread().threadId() + " : view rendering finished.");
    }
}

