/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form.record;

import java.util.Arrays;
import java.util.List;
import jp.ecuacion.lib.core.record.EclibRecord;
import jp.ecuacion.lib.core.record.item.EclibItem;
import jp.ecuacion.splib.web.bean.HtmlItem;
import jp.ecuacion.splib.web.bean.HtmlItemNumber;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public interface RecordInterface
extends EclibRecord {
    public HtmlItem[] getHtmlItems();

    default public HtmlItem[] getItems() {
        return this.getHtmlItems();
    }

    default public HtmlItem[] mergeHtmlItems(HtmlItem[] fields1, HtmlItem[] fields2) {
        EclibItem[] items = this.mergeItems(fields1, fields2);
        List<HtmlItem> list = Arrays.asList(items).stream().map(item -> (HtmlItem)((Object)item)).toList();
        return list.toArray(new HtmlItem[list.size()]);
    }

    default public HtmlItem getHtmlItem(String itemPropertyPath) {
        return (HtmlItem)this.getItem(itemPropertyPath);
    }

    default public HtmlItem getNewItem(String itemPropertyPath) {
        return new HtmlItem(itemPropertyPath);
    }

    default public boolean needsCommas(String rootRecordName, String propertyPath) {
        HtmlItem item = this.getHtmlItem(propertyPath);
        if (item == null || !(item instanceof HtmlItemNumber)) {
            return false;
        }
        HtmlItemNumber numItem = (HtmlItemNumber)item;
        return numItem.getNeedsCommas();
    }

    default public List<String> getNotEmptyFields(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmpty(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    default public boolean isNotEmpty(String fieldId, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getNotEmptyFields(loginState, bean).contains(fieldId);
    }

    @Deprecated
    default public List<String> getRequiredFields(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmpty(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    @Deprecated
    default public boolean isRequired(String fieldId, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getRequiredFields(loginState, bean).contains(fieldId);
    }

    default public List<String> getRequiredFieldsOnSearch(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmptyOnSearch(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    default public boolean isRequiredOnSearch(String fieldId, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getRequiredFieldsOnSearch(loginState, bean).contains(fieldId);
    }
}

