/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import java.util.HashMap;
import java.util.Map;
import jp.ecuacion.lib.core.logging.DetailLogger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="optUtil")
public class SplibThymeleafOptionUtil {
    private DetailLogger detailLog = new DetailLogger((Object)this);

    private Map<String, String> optionMap(String optionCsv) {
        String[] options;
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        if (optionCsv == null || optionCsv.equals("")) {
            return rtnMap;
        }
        String key = null;
        String value = null;
        for (String option : options = optionCsv.split(",")) {
            if (option.contains("=")) {
                key = StringUtils.trim((String)option.substring(0, option.indexOf("=")));
                value = StringUtils.trim((String)option.substring(option.indexOf("=") + 1));
            } else {
                key = option;
            }
            String lowerCaseKey = key.toLowerCase();
            if (rtnMap.containsKey(lowerCaseKey) && !lowerCaseKey.equals("")) {
                this.detailLog.warn("html key is dupliicated in options. Duplicated key: " + key);
            }
            rtnMap.put(lowerCaseKey, value);
        }
        return rtnMap;
    }

    public boolean hasKey(String options, String key) {
        return this.optionMap(options).containsKey(key.toLowerCase());
    }

    public String getValue(String options, String key) {
        return this.optionMap(options).get(key.toLowerCase());
    }

    public String getValueOrElse(String options, String key, String defaultValue) {
        if (this.hasKey(options, key)) {
            return this.getValue(options, key);
        }
        return defaultValue;
    }
}

