/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.ecuacion.splib.web.bean.HtmlItem;
import jp.ecuacion.splib.web.bean.HtmlItemNumber;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public interface RecordInterface {
    default public HtmlItem getHtmlItem(String rootRecordName, String itemPropertyPath) {
        Map<String, HtmlItem> map = Arrays.asList(this.getHtmlItems()).stream().collect(Collectors.toMap(e -> e.getItemPropertyPath(), e -> e));
        HtmlItem field = map.get(itemPropertyPath);
        if (field == null && itemPropertyPath.startsWith(rootRecordName)) {
            field = map.get(itemPropertyPath.substring(rootRecordName.length() + 1));
        }
        return field == null ? new HtmlItem(itemPropertyPath) : field;
    }

    public HtmlItem[] getHtmlItems();

    default public boolean needsCommas(String rootRecordName, String propertyPath) {
        HtmlItem item = this.getHtmlItem(rootRecordName, propertyPath);
        if (item == null || !(item instanceof HtmlItemNumber)) {
            return false;
        }
        HtmlItemNumber numItem = (HtmlItemNumber)item;
        return numItem.getNeedsCommas();
    }

    default public String getDisplayName(String rootRecordName, String propertyPathWithoutRootRecordName) {
        HtmlItem htmlItem = this.getHtmlItem(rootRecordName, propertyPathWithoutRootRecordName);
        String displayNameId = htmlItem.getItemNameKey(rootRecordName);
        return displayNameId.contains(".") ? displayNameId : propertyPathWithoutRootRecordName + "." + displayNameId;
    }

    default public HtmlItem[] mergeHtmlItems(HtmlItem[] fields1, HtmlItem[] fields2) {
        ArrayList<HtmlItem> list = new ArrayList<HtmlItem>(Arrays.asList(fields1));
        List<String> propertyPath1List = Arrays.asList(fields1).stream().map(e -> e.getItemPropertyPath()).toList();
        for (String propertyPath2 : Arrays.asList(fields2).stream().map(e -> e.getItemPropertyPath()).toList()) {
            if (!propertyPath1List.contains(propertyPath2)) continue;
            throw new RuntimeException("'id' of HtmlItem[] duplicated with commonHtmlItems. key: " + propertyPath2);
        }
        list.addAll(Arrays.asList(fields2));
        return list.toArray(new HtmlItem[list.size()]);
    }

    @Deprecated
    default public List<String> getNotEmptyFields(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmpty(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    @Deprecated
    default public boolean isNotEmpty(String fieldId, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getNotEmptyFields(loginState, bean).contains(fieldId);
    }

    default public List<String> getRequiredFields(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmpty(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    default public boolean isRequired(String fieldId, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getRequiredFields(loginState, bean).contains(fieldId);
    }

    default public List<String> getRequiredFieldsOnSearch(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return Arrays.asList(this.getHtmlItems()).stream().filter(item -> item.getIsNotEmptyOnSearch(loginState, bean)).map(item -> item.getItemPropertyPath()).toList();
    }

    default public boolean isRequiredOnSearch(String fieldId, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getRequiredFieldsOnSearch(loginState, bean).contains(fieldId);
    }
}

