/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.exceptionhandler;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.channels.OverlappingFileLockException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.AppWarningException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.exception.checked.ValidationAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import jp.ecuacion.splib.web.bean.HtmlItem;
import jp.ecuacion.splib.web.bean.MessagesBean;
import jp.ecuacion.splib.web.bean.ReturnUrlBean;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.exception.RedirectException;
import jp.ecuacion.splib.web.exception.RedirectToHomePageException;
import jp.ecuacion.splib.web.exception.WebAppWarningException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.form.record.RecordInterface;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibExceptionHandler {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    @Autowired
    HttpServletRequest request;
    @Autowired(required=false)
    SplibExceptionHandlerAction actionOnThrowable;
    @Autowired
    private SplibUtil util;

    @Nonnull
    protected SplibGeneralController<?> getController() {
        return (SplibGeneralController)this.getModel().getAttribute("controller");
    }

    @Nonnull
    private SplibGeneralForm[] getForms() {
        return (SplibGeneralForm[])this.getModel().getAttribute("forms");
    }

    @Nonnull
    private Model getModel() {
        return (Model)this.request.getAttribute("model");
    }

    @Nonnull
    private String addItemDisplayNames(@RequireNonnull String message, String ... itemNameKeys) {
        if (message.contains("{0}")) {
            message = MessageFormat.format(message, this.getItemDisplayNames((String[])ObjectsUtil.requireSizeNonZero((Object[])itemNameKeys)));
        }
        return message;
    }

    @Nonnull
    private String getItemDisplayNames(@RequireNonnull String[] itemNameKeys) {
        StringBuilder sb = new StringBuilder();
        String prependParenthesis = PropertyFileUtil.getMessage((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.prependParenthesis", (String[])new String[0]);
        String appendParenthesis = PropertyFileUtil.getMessage((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.appendParenthesis", (String[])new String[0]);
        String separator = PropertyFileUtil.getMessage((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.separator", (String[])new String[0]);
        boolean is1stTime = true;
        for (String itemNameKey : (String[])ObjectsUtil.requireNonNull((Object)itemNameKeys)) {
            if (PropertyFileUtil.hasItemName((String)itemNameKey)) {
                itemNameKey = PropertyFileUtil.getItemName((Locale)this.request.getLocale(), (String)itemNameKey);
            }
            if (is1stTime) {
                is1stTime = false;
            } else {
                sb.append(separator);
            }
            sb.append(prependParenthesis + itemNameKey + appendParenthesis);
        }
        return sb.toString();
    }

    @Nonnull
    private ModelAndView appExceptionFinalHandler(@Nonnull SplibGeneralController<?> ctrl, @Nullable UserDetails loginUser, boolean isRedirect, @Nullable ReturnUrlBean redirectBean) {
        SplibGeneralForm[] forms = (SplibGeneralForm[])this.getModel().getAttribute("forms");
        ((SplibGeneralService)this.getController().getService()).prepareForm(Arrays.asList(forms), loginUser);
        if (redirectBean == null) {
            redirectBean = new ReturnUrlBean(ctrl, this.util, false);
        }
        if (!isRedirect) {
            return new ModelAndView(ctrl.getDefaultHtmlPageName(), this.getModel().asMap());
        }
        String path = this.util.prepareForPageTransition(this.request, redirectBean, this.getModel(), true);
        return new ModelAndView(path);
    }

    @ExceptionHandler(value={AppWarningException.class})
    @Nonnull
    public ModelAndView handleAppWarningException(@Nonnull WebAppWarningException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        MessagesBean messagesBean = (MessagesBean)this.getModel().getAttribute("messagesBean");
        Objects.requireNonNull(messagesBean);
        messagesBean.setWarnMessage(new MessagesBean.WarnMessageBean(exception.getMessageId(), PropertyFileUtil.getMessage((Locale)this.request.getLocale(), (String)exception.getMessageId(), (String[])exception.getMessageArgs()), exception.buttonIdToPressOnConfirm()));
        return this.appExceptionFinalHandler(this.getController(), loginUser, false, null);
    }

    @ExceptionHandler(value={AppException.class})
    @Nonnull
    public ModelAndView handleAppException(@Nonnull AppException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        MessagesBean messagesBean = (MessagesBean)this.getModel().getAttribute("messagesBean");
        ArrayList<SingleAppException> exList = new ArrayList<SingleAppException>();
        if (exception instanceof MultipleAppException) {
            for (SingleAppException appEx : ((MultipleAppException)exception).getList()) {
                exList.add(appEx);
            }
            if (exList.size() == 0) {
                throw new RuntimeException("No exception included in MultipleAppException.");
            }
        } else {
            exList.add((SingleAppException)exception);
        }
        for (SingleAppException saex : exList) {
            List<String> itemPropertyPathList = Arrays.asList(saex.getItemPropertyPaths()).stream().map(itemPropertyPath -> StringUtils.uncapitalize((String)itemPropertyPath)).toList();
            if (saex instanceof BizLogicAppException && itemPropertyPathList.size() > 0 && !itemPropertyPathList.get(0).startsWith(this.getController().getRootRecordName() + ".")) {
                itemPropertyPathList = itemPropertyPathList.stream().map(path -> this.getController().getRootRecordName() + "." + path).toList();
            }
            String[] itemPropertyPaths = itemPropertyPathList.toArray(new String[itemPropertyPathList.size()]);
            Boolean msgAtItem = Boolean.valueOf(PropertyFileUtil.getApplication((String)"jp.ecuacion.splib.web.process-result-message.shown-at-each-item"));
            boolean needsItemName = msgAtItem == null ? true : msgAtItem == false;
            String message = (String)ExceptionUtil.getAppExceptionMessageList((AppException)saex, (Locale)this.request.getLocale(), (boolean)needsItemName).get(0);
            if (saex instanceof ValidationAppException) {
                ArrayList<String> itemNameKeyList = new ArrayList<String>();
                for (String propertyPath : (String[])ObjectsUtil.requireNonNull((Object)itemPropertyPaths)) {
                    HtmlItem item = ((RecordInterface)this.getForms()[0].getRootRecord(this.getController().getRootRecordName())).getHtmlItem(this.getController().getRootRecordName(), propertyPath);
                    itemNameKeyList.add(item.getItemNameKey(this.getController().getRootRecordName()));
                }
                message = this.addItemDisplayNames(message, itemNameKeyList.toArray(new String[itemNameKeyList.size()]));
            }
            messagesBean.setErrorMessage(message, itemPropertyPaths);
        }
        ReturnUrlBean redirectBean = this.getController().getRedirectUrlOnAppExceptionBean();
        return this.appExceptionFinalHandler(this.getController(), loginUser, true, redirectBean);
    }

    @ExceptionHandler(value={OverlappingFileLockException.class})
    @Nonnull
    public ModelAndView handleOptimisticLockingFailureException(@Nonnull OverlappingFileLockException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.handleAppException((AppException)new BizLogicAppException("jp.ecuacion.splib.web.common.message.optimisticLocking", new String[0]), loginUser);
    }

    @ExceptionHandler(value={NoResourceFoundException.class, RedirectException.class})
    @Nonnull
    public ModelAndView handleRedirectNeededExceptions(@RequireNonnull Exception exception, Model newModel) {
        RedirectToHomePageException redirectException = null;
        Model model = this.getModel();
        if (model == null) {
            model = newModel;
            newModel.addAttribute("messagesBean", (Object)new MessagesBean());
        }
        if (exception instanceof RedirectException) {
            redirectException = (RedirectToHomePageException)exception;
        } else {
            if (!StringUtils.isEmpty((CharSequence)exception.getMessage())) {
                this.detailLog.info(exception.getMessage());
            }
            if (exception instanceof NoResourceFoundException) {
                String path = ((NoResourceFoundException)exception).getResourcePath();
                redirectException = new RedirectToHomePageException("jp.ecuacion.splib.web.common.message.NoResourceFoundException", path);
            } else {
                redirectException = new RedirectToHomePageException();
            }
        }
        if (redirectException.getLogLevel() != null) {
            this.detailLog.log(redirectException.getLogLevel(), redirectException.getLogString());
        }
        if (!StringUtils.isEmpty((CharSequence)redirectException.getMessageId())) {
            MessagesBean messagesBean = (MessagesBean)model.getAttribute("messagesBean");
            messagesBean.setErrorMessage(PropertyFileUtil.getMessage((Locale)this.request.getLocale(), (String)redirectException.getMessageId(), (String[])redirectException.getMessageArgs()), new String[0]);
        }
        ReturnUrlBean redirectBean = new ReturnUrlBean(redirectException.getRedirectPath());
        String path = this.util.prepareForPageTransition(this.request, redirectBean, model, true);
        return new ModelAndView(path);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ModelAndView handleThrowable(@Nonnull Throwable exception, @Nonnull Model model) {
        LogUtil.logSystemError((DetailLogger)this.detailLog, (Throwable)exception);
        if (this.actionOnThrowable != null) {
            this.actionOnThrowable.execute(exception);
        }
        Model mdl = this.getModel() == null ? model : this.getModel();
        return new ModelAndView("error", mdl.asMap(), HttpStatusCode.valueOf((int)500));
    }
}

