/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.advice;

import jp.ecuacion.splib.core.form.record.SplibRecord;
import jp.ecuacion.splib.web.service.SplibDataStoreDependentControllerAdviceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class SplibDataStoreDependentControllerAdvice {
    @Autowired
    SplibDataStoreDependentControllerAdviceService service;

    @ModelAttribute
    protected void setAccountInfo(Model model, @AuthenticationPrincipal UserDetails loginUser) {
        this.executeForAll();
        if (loginUser == null) {
            return;
        }
        if (loginUser.getAuthorities().stream().map(e -> e.getAuthority()).filter(auth -> auth.startsWith("ROLE_ADMIN")).toList().size() > 0) {
            SplibRecord adminLoginAcc = this.service.getAdminLoginAcc(loginUser);
            model.addAttribute("loginAcc", (Object)adminLoginAcc);
            this.executeForAdminAccount(adminLoginAcc);
        } else {
            SplibRecord loginAcc = this.service.getLoginAcc(loginUser);
            model.addAttribute("loginAcc", (Object)loginAcc);
            this.executeForAccount(loginAcc);
        }
    }

    protected void executeForAll() {
    }

    protected void executeForAdminAccount(SplibRecord adminAcc) {
    }

    protected void executeForAccount(SplibRecord acc) {
    }
}

