/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import jp.ecuacion.splib.web.bean.HtmlItem;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.form.record.RecordInterface;
import org.springframework.stereotype.Component;
import org.thymeleaf.util.StringUtils;

@Component(value="recUtil")
public class SplibRecordUtil {
    public HtmlItem getHtmlField(SplibGeneralForm form, String rootRecordId, String itemId) {
        if (!StringUtils.capitalize((Object)itemId).startsWith(StringUtils.capitalize((Object)rootRecordId) + ".")) {
            throw new RuntimeException("itemId: " + itemId + " does not start with rootRecordId: " + rootRecordId + " plus dot(.).");
        }
        String fieldId = itemId.substring((rootRecordId + ".").length());
        return this.getHtmlField(((RecordInterface)form.getRootRecord(rootRecordId)).getHtmlFields(), fieldId);
    }

    public HtmlItem getHtmlField(SplibGeneralForm[] forms, String rootRecordId, String itemId) {
        return this.getHtmlField(forms[0], rootRecordId, itemId);
    }

    public HtmlItem getHtmlField(HtmlItem[] htmlFields, String fieldId) {
        HtmlItem field = Arrays.asList(htmlFields).stream().collect(Collectors.toMap(e -> e.getItemIdField(), e -> e)).get(fieldId);
        return field == null ? new HtmlItem(fieldId) : field;
    }
}

