/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.splib.web.bean.ReturnUrlBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.controller.SplibGeneral1FormController;
import jp.ecuacion.splib.web.controller.SplibGeneral2FormsController;
import jp.ecuacion.splib.web.exception.FormInputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneral1FormService;
import jp.ecuacion.splib.web.service.SplibGeneral2FormsService;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibGeneralController<S extends SplibGeneralService>
extends SplibBaseController {
    protected ControllerContext context;
    protected SplibSecurityUtil.RolesAndAuthoritiesBean rolesAndAuthoritiesBean;
    @Autowired
    protected List<S> serviceList;
    @Autowired
    private SplibUtil util;
    protected ReturnUrlBean redirectUrlOnAppExceptionBean;
    protected List<String[]> paramListOnRedirectToSelf = new ArrayList<String[]>();

    public static ControllerContext newContext() {
        return new ControllerContext();
    }

    public S getService() {
        Class cls = null;
        cls = this instanceof SplibGeneral1FormController ? SplibGeneral1FormService.class : (this instanceof SplibGeneral2FormsController ? SplibGeneral2FormsService.class : SplibGeneralService.class);
        Class<SplibGeneral1FormService> cls2 = cls;
        List<SplibGeneralService> list = this.serviceList.stream().filter(e -> cls2.isAssignableFrom(e.getClass())).toList();
        if (list.size() != 1) {
            throw new RuntimeException("Injected service not 1.");
        }
        return (S)list.get(0);
    }

    public SplibGeneralController(@Nonnull String function) {
        this(function, SplibGeneralController.newContext());
    }

    protected SplibGeneralController(@Nonnull String function, @NonNull ControllerContext context) {
        context.function(function);
        this.context = context;
    }

    public String getFunction() {
        return this.context.function();
    }

    public String getSubFunction() {
        return this.context.subFunction();
    }

    public String getRootRecordName() {
        return this.context.rootRecordName();
    }

    public ReturnUrlBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    protected void addParamToParamListOnRedirectToSelf(String key) {
        this.paramListOnRedirectToSelf.add(new String[]{key, ""});
    }

    protected void addParamToParamListOnRedirectToSelf(String key, String value) {
        this.paramListOnRedirectToSelf.add(new String[]{key, value});
    }

    public List<String[]> getParamListOnRedirectToSelf() {
        return this.paramListOnRedirectToSelf;
    }

    @ModelAttribute
    private void setParamsToModel(Model model, @AuthenticationPrincipal UserDetails loginUser) {
        model.addAttribute("function", (Object)this.context.function());
        model.addAttribute("rootRecordName", (Object)this.context.rootRecordName());
        this.rolesAndAuthoritiesBean = loginUser == null ? new SplibSecurityUtil().getRolesAndAuthoritiesBean() : new SplibSecurityUtil().getRolesAndAuthoritiesBean(loginUser);
        model.addAttribute("rolesAndAuthorities", (Object)this.rolesAndAuthoritiesBean);
    }

    protected String getRedirectUrlOnSuccess() {
        return new ReturnUrlBean(this, this.util).showSuccessMessage().getUrl();
    }

    public String redirectToSamePageTakingOverModel(Model model) {
        return this.redirectToSamePageTakingOverModel(model, false);
    }

    public String redirectToSamePageTakingOverModel(Model model, boolean showsSuccessMessage) {
        ReturnUrlBean bean = new ReturnUrlBean(this, this.util);
        if (showsSuccessMessage) {
            bean.showSuccessMessage();
        }
        return this.util.prepareForPageTransition(this.request, this, bean, model, false);
    }

    @GetMapping(value={"action"})
    public void throw404() throws NoResourceFoundException {
        throw new NoResourceFoundException(HttpMethod.GET, "from SplibGeneralController#throw404");
    }

    public String getDefaultHtmlPageName() {
        return this.context.function() + StringUtils.capitalize((String)(this.context.htmlFilenamePostfix() == null ? this.context.subFunction() : this.context.htmlFilenamePostfix()));
    }

    public String getDefaultDestSubFunctionOnNormalEnd() {
        return this.context.subFunction();
    }

    public String getDefaultDestSubFunctionOnAbnormalEnd() {
        return this.context.subFunction();
    }

    public String getDefaultDestPageOnNormalEnd() {
        return "page";
    }

    public String getDefaultDestPageOnAbnormalEnd() {
        return "page";
    }

    public void prepare(Model model, SplibGeneralForm ... forms) throws FormInputValidationException, AppException {
        this.prepare(model, (UserDetails)null, forms);
    }

    public void prepare(Model model, UserDetails loginUser, SplibGeneralForm ... forms) throws FormInputValidationException, AppException {
        for (SplibGeneralForm form : forms) {
            model.addAttribute((Object)form);
            form.setControllerContext(this.context);
        }
        model.addAttribute("forms", (Object)forms);
        model.addAttribute("controller", (Object)this);
        this.transactionTokenCheck();
        for (SplibGeneralForm form : forms) {
            if (!form.getPrepareSettings().validates()) continue;
            this.validationCheck(form, form.getPrepareSettings().bindingResult(), this.util.getLoginState(), this.rolesAndAuthoritiesBean);
        }
    }

    private void transactionTokenCheck() throws BizLogicAppException {
        String forward = this.request.getParameter("forward");
        if (forward != null && forward.equals("true")) {
            return;
        }
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new BizLogicAppException(msgId, new String[0]);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result, String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) throws FormInputValidationException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError(loginState, bean);
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            throw new FormInputValidationException(form);
        }
    }

    public static class ControllerContext {
        @Nonnull
        private String function;
        @Nonnull
        private String subFunction = "";
        @Nullable
        private String htmlFilenamePostfix;
        @Nullable
        private String rootRecordName;

        ControllerContext() {
        }

        @Nonnull
        public ControllerContext function(String function) {
            this.function = function == null ? "" : function;
            return this;
        }

        @Nonnull
        public String function() {
            return this.function;
        }

        @Nonnull
        public ControllerContext subFunction(@RequireNonnull String subFunction) {
            this.subFunction = (String)ObjectsUtil.requireNonNull((Object)subFunction);
            return this;
        }

        @Nonnull
        public String subFunction() {
            return this.subFunction;
        }

        @Nonnull
        public ControllerContext htmlFilenamePostfix(String htmlFilenamePostfix) {
            this.htmlFilenamePostfix = htmlFilenamePostfix;
            return this;
        }

        @Nullable
        public String htmlFilenamePostfix() {
            return this.htmlFilenamePostfix;
        }

        @Nonnull
        public ControllerContext rootRecordName(String rootRecordName) {
            this.rootRecordName = rootRecordName;
            return this;
        }

        @Nonnull
        public String rootRecordName() {
            return this.rootRecordName == null ? this.function : this.rootRecordName;
        }
    }
}

