/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public class HtmlField {
    @Nonnull
    protected String id;
    protected String displayNameId;
    protected HtmlFieldConditionContainer<Boolean> isNotEmpty = new HtmlFieldConditionContainer<Boolean>(false);

    public HtmlField(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public HtmlField displayNameId(String displayNameId) {
        this.displayNameId = displayNameId;
        return this;
    }

    public String getDisplayNameId() {
        return this.displayNameId;
    }

    public HtmlField isNotEmpty(boolean isNotEmpty) {
        this.isNotEmpty.setDefaultValue(isNotEmpty);
        return this;
    }

    public HtmlField isNotEmpty(HtmlFieldConditionKeyEnum authKind, String authString, boolean isNotEmpty) {
        this.isNotEmpty.add(new HtmlFieldCondition<Boolean>(authKind, authString, isNotEmpty));
        return this;
    }

    public boolean getIsNotEmpty(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isNotEmpty.getValue(loginState, bean);
    }

    public static class HtmlFieldConditionContainer<T> {
        private List<HtmlFieldCondition<T>> list = new ArrayList<HtmlFieldCondition<T>>();
        private T defaultValue;

        public HtmlFieldConditionContainer(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void add(HtmlFieldCondition<T> authInfo) {
            this.getList().add(authInfo);
        }

        private List<HtmlFieldCondition<T>> getList() {
            return this.list;
        }

        public void setList(List<HtmlFieldCondition<T>> list) {
            this.list = list;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getValue(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
            if (this.list == null) {
                this.list = new ArrayList<HtmlFieldCondition<T>>();
            }
            for (HtmlFieldCondition<T> info : this.list) {
                if (info.getConditionKey() == HtmlFieldConditionKeyEnum.LOGIN_STATE) {
                    if (!info.getConditionValue().equals(loginState)) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlFieldConditionKeyEnum.ROLE) {
                    if (!bean.getRoleList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlFieldConditionKeyEnum.AUTHORITY) {
                    if (!bean.getAuthorityList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlFieldConditionKeyEnum.KEYWORD) {
                    if (!bean.getAuthorityList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                throw new RuntimeException("Set appropriate one of the AuthKindEnum values");
            }
            return this.defaultValue;
        }
    }

    public static class HtmlFieldCondition<T> {
        private HtmlFieldConditionKeyEnum conditionKey;
        private String conditionValue;
        private T value;

        public HtmlFieldCondition(HtmlFieldConditionKeyEnum conditionKey, String conditionValue, T value) {
            this.conditionKey = conditionKey;
            this.conditionValue = conditionValue;
            this.value = value;
        }

        public HtmlFieldConditionKeyEnum getConditionKey() {
            return this.conditionKey;
        }

        public String getConditionValue() {
            return this.conditionValue;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static enum HtmlFieldConditionKeyEnum {
        LOGIN_STATE,
        ROLE,
        AUTHORITY,
        KEYWORD;

    }
}

