/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.service;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppExceptionItemIds;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.web.exception.WebAppWarningException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SplibGeneralService {
    @Autowired
    private HttpServletRequest request;
    private DetailLogger detailLog = new DetailLogger((Object)this);

    protected void throwWarning(@RequireNonnull Set<String> confirmedWarningMessageSet, @RequireNonnull Locale locale, @Nullable String buttonIdToPressOnConfirm, @Nullable AppExceptionItemIds fields, @RequireNonnull String msgId, String ... params) throws WebAppWarningException {
        if (!((Set)ObjectsUtil.paramRequireNonNull(confirmedWarningMessageSet)).contains(msgId)) {
            throw new WebAppWarningException(locale, msgId, params).itemIds(fields).buttonIdToPressOnConfirm(buttonIdToPressOnConfirm);
        }
    }

    public DatetimeFormatParameters getParams() {
        return new SplibUtil().getParams(this.request);
    }

    public void prepareForm(List<SplibGeneralForm> allFormList, UserDetails loginUser) {
        this.detailLog.debug("prepareForm(List<SplibGeneralForm> allFormList, UserDetails loginUser) called.");
    }
}

