/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.exceptionhandler;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import java.nio.channels.OverlappingFileLockException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.beanvalidation.bean.BeanValidationErrorInfoBean;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.AppWarningException;
import jp.ecuacion.lib.core.exception.checked.BeanValidationAppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.BeanValidationUtil;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.core.exceptionhandler.SplibExceptionHandlerAction;
import jp.ecuacion.splib.web.bean.HtmlField;
import jp.ecuacion.splib.web.bean.MessagesBean;
import jp.ecuacion.splib.web.bean.ReturnUrlBean;
import jp.ecuacion.splib.web.bean.SplibModelAttributes;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.exception.BizLogicRedirectAppException;
import jp.ecuacion.splib.web.exception.FormInputValidationException;
import jp.ecuacion.splib.web.exception.HtmlFileNotAllowedToOpenException;
import jp.ecuacion.splib.web.exception.HtmlFileNotFoundException;
import jp.ecuacion.splib.web.exception.WebAppWarningException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibRecordUtil;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibExceptionHandler {
    private LogUtil logUtil = new LogUtil((Object)this);
    private DetailLogger detailLog = new DetailLogger((Object)this);
    @Autowired
    SplibRecordUtil recUtil;
    @Autowired
    HttpServletRequest request;
    @Autowired
    SplibExceptionHandlerAction actionOnThrowable;
    @Autowired
    private SplibModelAttributes modelAttr;
    @Autowired
    private SplibUtil util;

    @Nonnull
    protected SplibGeneralController<?> getController() {
        return (SplibGeneralController)this.getModel().getAttribute("controller");
    }

    @Nonnull
    private SplibGeneralForm[] getForms() {
        return (SplibGeneralForm[])this.getModel().getAttribute("forms");
    }

    @Nonnull
    private Model getModel() {
        return (Model)this.request.getAttribute("model");
    }

    @Nonnull
    private String addItemDisplayNames(@RequireNonnull String message, String ... itemIds) {
        if (message.contains("{0}")) {
            message = MessageFormat.format(message, this.getItemDisplayNames((String[])ObjectsUtil.paramSizeNonZero((Object[])itemIds)));
        }
        return message;
    }

    @Nonnull
    private String getItemDisplayNames(@RequireNonnull String[] itemIds) {
        StringBuilder sb = new StringBuilder();
        String prependParenthesis = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.prependParenthesis", (String[])new String[0]);
        String appendParenthesis = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.appendParenthesis", (String[])new String[0]);
        String separator = PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)"jp.ecuacion.splib.web.common.message.itemName.separator", (String[])new String[0]);
        boolean is1stTime = true;
        for (String itemId : (String[])ObjectsUtil.paramRequireNonNull((Object)itemIds)) {
            if (PropertyFileUtil.hasItemName((String)itemId)) {
                itemId = PropertyFileUtil.getItemName((Locale)this.request.getLocale(), (String)itemId);
            }
            if (is1stTime) {
                is1stTime = false;
            } else {
                sb.append(separator);
            }
            sb.append(prependParenthesis + itemId + appendParenthesis);
        }
        return sb.toString();
    }

    @Nonnull
    private ModelAndView appExceptionFinalHandler(@Nonnull SplibGeneralController<?> ctrl, @Nullable UserDetails loginUser, boolean isRedirect, @Nullable ReturnUrlBean redirectBean) {
        SplibGeneralForm[] forms = (SplibGeneralForm[])this.getModel().getAttribute("forms");
        ((SplibGeneralService)this.getController().getService()).prepareForm(Arrays.asList(forms), loginUser);
        if (redirectBean == null) {
            redirectBean = new ReturnUrlBean(ctrl, this.util, false);
        }
        if (!isRedirect) {
            return new ModelAndView(ctrl.getDefaultHtmlPageName(), this.getModel().asMap());
        }
        String path = this.util.prepareForPageTransition(this.request, ctrl, redirectBean, this.getModel(), true);
        return new ModelAndView(path);
    }

    @ExceptionHandler(value={AppWarningException.class})
    @Nonnull
    public ModelAndView handleAppWarningException(@Nonnull WebAppWarningException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        MessagesBean requestResult = (MessagesBean)this.getModel().getAttribute("responseMessages");
        Objects.requireNonNull(requestResult);
        requestResult.setWarnMessage(new MessagesBean.WarnMessageBean(exception.getMessageId(), PropertyFileUtil.getMsg((Locale)this.request.getLocale(), (String)exception.getMessageId(), (String[])exception.getMessageArgs()), exception.buttonIdToPressOnConfirm()));
        return this.appExceptionFinalHandler(this.getController(), loginUser, false, null);
    }

    @ExceptionHandler(value={AppException.class})
    @Nonnull
    public ModelAndView handleAppException(@Nonnull AppException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        ReturnUrlBean redirectBean = null;
        MessagesBean requestResult = (MessagesBean)this.getModel().getAttribute("responseMessages");
        ArrayList<Object> exList = new ArrayList<Object>();
        if (exception instanceof MultipleAppException) {
            for (SingleAppException singleAppException : ((MultipleAppException)exception).getList()) {
                exList.add(singleAppException);
            }
            if (exList.size() == 0) {
                throw new RuntimeException("No exception included in MultipleAppException.");
            }
        } else if (exception instanceof FormInputValidationException) {
            List<BeanValidationAppException> list = this.getBeanValidationAppExceptionList((FormInputValidationException)exception, loginUser);
            exList.addAll(list);
        } else {
            exList.add((SingleAppException)exception);
        }
        for (SingleAppException singleAppException : exList) {
            if (singleAppException instanceof BizLogicRedirectAppException) {
                String redirectPath = ((BizLogicRedirectAppException)singleAppException).getRedirectPath();
                redirectBean = new ReturnUrlBean(this.getController(), redirectPath);
                continue;
            }
            String[] itemIds = null;
            String rootRecordIdPlusDot = this.getController().getRootRecordName() + ".";
            if (singleAppException instanceof BizLogicAppException) {
                BizLogicAppException ex = (BizLogicAppException)singleAppException;
                List<String> itemIdList = Arrays.asList(ex.getErrorFields() == null ? new String[]{} : ex.getErrorFields().getFields()).stream().map(fieldId -> fieldId.startsWith(rootRecordIdPlusDot) ? fieldId : rootRecordIdPlusDot + fieldId).toList();
                itemIds = itemIdList.toArray(new String[itemIdList.size()]);
            } else if (singleAppException instanceof BeanValidationAppException) {
                String[] stringArray;
                String id = ((BeanValidationAppException)singleAppException).getBeanValidationErrorInfoBean().getPropertyPath();
                if (id.contains(".")) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = id;
                } else {
                    stringArray = new String[]{};
                }
                itemIds = stringArray;
            }
            String message = (String)new ExceptionUtil().getAppExceptionMessageList((AppException)singleAppException, this.request.getLocale()).get(0);
            ArrayList<Object> displayNameIdList = new ArrayList<Object>();
            for (String itemId : (String[])ObjectsUtil.paramRequireNonNull((Object)itemIds)) {
                HtmlField field = this.recUtil.getHtmlField(this.getForms(), this.getController().getRootRecordName(), itemId);
                displayNameIdList.add(field.getDisplayNameId() == null ? this.getController().getRootRecordName() + "." + field.getId() : field.getDisplayNameId());
            }
            message = this.addItemDisplayNames(message, displayNameIdList.toArray(new String[displayNameIdList.size()]));
            requestResult.setErrorMessage(message, itemIds);
        }
        redirectBean = redirectBean == null ? this.getController().getRedirectUrlOnAppExceptionBean() : redirectBean;
        return this.appExceptionFinalHandler(this.getController(), loginUser, true, redirectBean);
    }

    private List<BeanValidationAppException> getBeanValidationAppExceptionList(FormInputValidationException exception, UserDetails loginUser) {
        ArrayList<BeanValidationErrorInfoBean> errorList = new ArrayList<BeanValidationErrorInfoBean>();
        for (ConstraintViolation cv : new BeanValidationUtil().validate((Object)exception.getForm())) {
            errorList.add(new BeanValidationErrorInfoBean(cv));
        }
        errorList.addAll(exception.getForm().validateNotEmpty(this.request.getLocale(), this.util.getLoginState(), new SplibSecurityUtil().getRolesAndAuthoritiesBean(loginUser)).stream().collect(Collectors.toList()));
        errorList = errorList.stream().sorted(this.getComparator()).collect(Collectors.toList());
        this.removeDuplicatedValidators(errorList);
        if (errorList.size() == 0) {
            String msg = "SplibExceptionHandler#handleInputValidationException\u306b\u6765\u3066\u3044\u308b\u306e\u306berrorList\u306b\u30a8\u30e9\u30fc\u9805\u76ee\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\nrootRecoordName\u3068\u540c\u4e00\u306ename\u3092\u6301\u3063\u305fsubmit\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u305f\u5834\u5408\u306b\u767a\u751f\u3059\u308b\u6a21\u69d8\u3002\n\uff08\u4f8b\uff1arootRecordName\u3092app\u3068\u3057\u305f\u5834\u5408\u3001\u4ee5\u4e0b\u306e\u3088\u3046\u306a\u30dc\u30bf\u30f3\u3092\u4f5c\u6210\u3059\u308b\u5834\u5408\u306b\u767a\u751f\uff09\n<div th:replace=\"~{bootstrap/components :: commonPrimaryButton('app', ...)}\"></div>\n\ntext\u306a\u3069\u306e\u60c5\u5831\u306f\u3001GET\u3067\u3044\u3046\u3068\u3001request param\u306e\u4e2d\u3067\"app.desc=...\"\u306e\u3088\u3046\u306b\u8a18\u8f09\u3055\u308c\u308b\u304c\u3001\u305d\u306eparameter\u306e\u4e2d\u3067\nspring mvc\u3060\u3068\u30dc\u30bf\u30f3\u540d\u304c\"app=\"\u3068\u51fa\u308b\u3002\n\u3053\u306e\u30dc\u30bf\u30f3\u540d\u306b\u5bfe\u3059\u308b\"app=\"\u3092\u3001\"app\"\u306e\u30ad\u30fc\u30ef\u30fc\u30c9\u304c\u3042\u308b\u305f\u3081form\u3078\u306emapping\u5bfe\u8c61\u3060\u3068spring\u304c\u52d8\u9055\u3044\u3059\u308b\u305f\u3081\u306b\u3001\nmapping\u3092\u30c8\u30e9\u30a4\u3057\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u3066\u3044\u308b\u306e\u304b\u3082\u3002\n\uff08\u3061\u306a\u307f\u306b\u3001\u30dc\u30bf\u30f3\u306ename\u304cappzzz\u306a\u3069\u3001app\u304b\u3089\u59cb\u307e\u308b\u304capp\u3068\u306f\u7570\u306a\u308b\u6587\u5b57\u5217\u3067\u3042\u308c\u3070\u3001\u3053\u306e\u554f\u984c\u306f\u767a\u751f\u3057\u306a\u3044\uff09\n";
            throw new RuntimeException(msg);
        }
        return errorList.stream().map(bean -> new BeanValidationAppException(bean)).toList();
    }

    private void removeDuplicatedValidators(List<BeanValidationErrorInfoBean> cvList) {
        HashMap duplicateCheckMap = new HashMap();
        HashSet<String> keySetWithNotEmpty = new HashSet<String>();
        for (BeanValidationErrorInfoBean cv : cvList) {
            String key = cv.getPropertyPath().toString();
            if (duplicateCheckMap.get(key) == null) {
                duplicateCheckMap.put(key, new HashSet());
            }
            ((Set)duplicateCheckMap.get(key)).add(cv);
            if (!this.isNotEmptyValidator(cv)) continue;
            keySetWithNotEmpty.add(key);
        }
        for (String key : keySetWithNotEmpty) {
            for (BeanValidationErrorInfoBean cv : (Set)duplicateCheckMap.get(key)) {
                if (this.isNotEmptyValidator(cv)) continue;
                cvList.remove(cv);
            }
        }
    }

    private boolean isNotEmptyValidator(BeanValidationErrorInfoBean cv) {
        String validatorClass = cv.getValidatorClass();
        return validatorClass.endsWith("NotEmpty") || validatorClass.endsWith("NotEmptyIfValid");
    }

    private Comparator<BeanValidationErrorInfoBean> getComparator() {
        return new Comparator<BeanValidationErrorInfoBean>(this){

            @Override
            public int compare(BeanValidationErrorInfoBean f1, BeanValidationErrorInfoBean f2) {
                int result = f1.getPropertyPath().toString().compareTo(f2.getPropertyPath().toString());
                if (result != 0) {
                    return result;
                }
                result = f1.getValidatorClass().compareTo(f2.getValidatorClass());
                if (result != 0) {
                    return result;
                }
                String s1 = f1.getAnnotationDescriptionString();
                String s2 = f2.getAnnotationDescriptionString();
                return s1.compareTo(s2);
            }
        };
    }

    @ExceptionHandler(value={OverlappingFileLockException.class})
    @Nonnull
    public ModelAndView handleOptimisticLockingFailureException(@Nonnull OverlappingFileLockException exception, @Nullable @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.handleAppException((AppException)new BizLogicAppException("jp.ecuacion.splib.web.common.message.optimisticLocking", new String[0]), loginUser);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @Nonnull
    public ModelAndView handleHttpRequestMethodNotSupportedException(@Nonnull HttpRequestMethodNotSupportedException exception) {
        this.logUtil.logError((Throwable)exception, this.request.getLocale());
        this.actionOnThrowable.execute((Throwable)exception);
        return new ModelAndView("redirect:/" + PropertyFileUtil.getApp((String)"jp.ecuacion.splib.web.system-error.go-to-path"));
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    public void handleNoResourceFoundException(@Nonnull NoResourceFoundException exception) throws NoResourceFoundException {
        throw exception;
    }

    @ExceptionHandler(value={HtmlFileNotFoundException.class})
    @Nonnull
    public ModelAndView handleHtmlFileNotFoundException(@Nonnull HtmlFileNotFoundException exception) {
        this.detailLog.info("Designated html file not found. html file name = " + exception.getFileName());
        return new ModelAndView("redirect:/public/home/page");
    }

    @ExceptionHandler(value={HtmlFileNotAllowedToOpenException.class})
    @Nonnull
    public ModelAndView handleHtmlFileNotAllowedToOpenException(@Nonnull HtmlFileNotAllowedToOpenException exception) {
        this.detailLog.info("Designated html file not allowed to open. Needs to add option to html tag. html file name = " + exception.getFileName());
        return new ModelAndView("redirect:/public/home/page");
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ModelAndView handleThrowable(@Nonnull Throwable exception, @Nonnull Model model) {
        this.logUtil.logError(exception, this.request.getLocale());
        this.actionOnThrowable.execute(exception);
        Model mdl = this.getModel() == null ? model : this.getModel();
        this.modelAttr.addAllToModel(mdl);
        return new ModelAndView("error", mdl.asMap(), HttpStatusCode.valueOf((int)500));
    }
}

