/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.service;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppWarningException;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SplibGeneralService {
    @Autowired
    private HttpServletRequest request;

    protected void throwWarning(Set<String> confirmedWarningMessageSet, Locale locale, String msgId) throws AppWarningException {
        if (!confirmedWarningMessageSet.contains(msgId)) {
            throw new AppWarningException(locale, msgId, new String[0]);
        }
    }

    protected void throwWarning(Set<String> confirmedWarningMessageSet, Locale locale, String buttonName, String msgId, String ... params) throws AppWarningException {
        if (!confirmedWarningMessageSet.contains(msgId)) {
            throw new AppWarningException(locale, buttonName, null, msgId, params);
        }
    }

    protected String getLockFileVersion(File lockFile) throws IOException {
        lockFile.getParentFile().mkdirs();
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        return Instant.ofEpochMilli(lockFile.lastModified()).atOffset(ZoneOffset.ofHours(0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss.SSS"));
    }

    protected void fileLock(File lockFile, String version, SplibGeneralForm form) throws Exception {
        FileLock lockedObject = null;
        try (FileChannel channel = FileChannel.open(lockFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            lockedObject = channel.tryLock();
            if (lockedObject == null) {
                throw new OverlappingFileLockException();
            }
            String fileTimestamp = this.getLockFileVersion(lockFile);
            if (!version.equals(fileTimestamp)) {
                throw new OverlappingFileLockException();
            }
            this.exclusiveLockActivatedByLockFile(lockFile, form);
            ByteBuffer src = ByteBuffer.allocate(30);
            byte[] bytes = LocalDateTime.now().toString().getBytes();
            src.put(bytes);
            src.position(0);
            channel.write(src);
            lockedObject.release();
        }
        catch (IOException | OverlappingFileLockException ex) {
            throw new OverlappingFileLockException();
        }
    }

    protected void exclusiveLockActivatedByLockFile(File lockFile, SplibGeneralForm form) throws Exception {
    }

    protected LocalDate localDate(String date) {
        return date == null || date.equals("") ? null : LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public DatetimeFormatParameters getParams() {
        return new SplibUtil().getParams(this.request);
    }

    public void prepareForm(List<SplibGeneralForm> allFormList, UserDetails loginUser) {
        System.out.println("prepareForm(List<SplibGeneralForm> allFormList, UserDetails loginUser) called.");
    }
}

