/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.config;

import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.splib.core.bean.AuthorizationBean;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public abstract class SplibWebSecurityConfig {
    public static final String ACCOUNT_FULL_ACCESS = "ACCOUNT_FULL_ACCESS";
    protected PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    protected abstract String getDefaultSuccessUrl();

    protected abstract String getUrlWithLoginNeededPageAccessed();

    protected abstract List<AuthorizationBean> getRoleInfo();

    protected abstract List<AuthorizationBean> getAuthorityInfo();

    protected String getAccessDeniedPage() {
        return "/public/login/page?accessDenied";
    }

    @Bean
    PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    @Bean
    MvcRequestMatcher.Builder mvc(HandlerMappingIntrospector introspector) {
        return new MvcRequestMatcher.Builder(introspector);
    }

    @Bean
    SecurityFilterChain filterChain(HttpSecurity http, MvcRequestMatcher.Builder mvc) throws Exception {
        http.httpBasic(basic -> basic.disable());
        http.formLogin(login -> ((FormLoginConfigurer)((FormLoginConfigurer)login.loginPage(this.getUrlWithLoginNeededPageAccessed()).loginProcessingUrl("/public/login/action")).usernameParameter("login.username").passwordParameter("login.password").defaultSuccessUrl(this.getDefaultSuccessUrl(), true)).failureUrl("/public/login/page?error"));
        http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/public/**")})).permitAll().requestMatchers(new RequestMatcher[]{mvc.pattern("/ecuacion/public/**")})).permitAll());
        ArrayList<AuthorizationBean> roleList = this.getRoleInfo() == null ? new ArrayList<AuthorizationBean>() : new ArrayList<AuthorizationBean>(this.getRoleInfo());
        roleList.add(new AuthorizationBean("/account/**", ACCOUNT_FULL_ACCESS));
        for (AuthorizationBean bean : roleList) {
            http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(bean.getRequestMatchers())).hasAnyRole(bean.addAndGetRolesOrAuthorities(ACCOUNT_FULL_ACCESS)));
        }
        if (this.getAuthorityInfo() != null) {
            for (AuthorizationBean bean : this.getAuthorityInfo()) {
                http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(bean.getRequestMatchers())).hasAnyAuthority(bean.getRolesOrAuthorities()));
            }
        }
        http.authorizeHttpRequests(requests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).denyAll());
        http.logout(logout -> logout.logoutUrl("/public/logout").logoutSuccessUrl("/public/login/page?logoutDone"));
        http.exceptionHandling(handling -> handling.accessDeniedPage(this.getAccessDeniedPage()));
        return (SecurityFilterChain)http.build();
    }
}

