/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.splib.web.bean.ReturnUrlBean;
import jp.ecuacion.splib.web.controller.SplibGeneral2FormsController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.exception.FormInputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.form.SplibListForm;
import jp.ecuacion.splib.web.form.SplibSearchForm;
import jp.ecuacion.splib.web.service.SplibSearchListService;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibSearchListController<FST extends SplibSearchForm, FLT extends SplibListForm<?>, S extends SplibSearchListService<FST, FLT>>
extends SplibGeneral2FormsController<FST, FLT, S> {
    @Autowired
    private FST newSearchForm;
    @Autowired
    private SplibUtil util;

    public SplibSearchListController(@Nonnull String function) {
        this(function, new SplibGeneralController.ControllerContext());
    }

    public SplibSearchListController(@Nonnull String function, SplibGeneralController.ControllerContext settings) {
        super(function, settings.subFunction("searchList"));
    }

    @Override
    public String getDefaultDestSubFunctionOnNormalEnd() {
        return "searchList";
    }

    @Override
    public String submitOnChangeToRefresh(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        searchForm = this.getProperSearchForm(model, searchForm);
        super.submitOnChangeToRefresh(model, searchForm, listForm, loginUser);
        return new ReturnUrlBean(this, this.util, "searchList", "page").showSuccessMessage().getUrl();
    }

    @Override
    public String page(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        searchForm = this.getProperSearchForm(model, searchForm);
        ((SplibGeneralForm)listForm).setDataKind(((SplibGeneralForm)searchForm).getDataKind());
        this.redirectUrlOnAppExceptionBean = new ReturnUrlBean(this, this.util, false);
        this.prepare(model, loginUser, new SplibGeneralForm[]{searchForm, listForm});
        ((SplibSearchListService)this.getService()).page(searchForm, listForm, loginUser);
        ((SplibSearchListService)this.getService()).prepareForm(searchForm, listForm, loginUser);
        return this.getDefaultHtmlPageName();
    }

    @GetMapping(value={"action"}, params={"search"})
    public String search(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, new SplibGeneralForm[]{searchForm, listForm});
        return this.redirectToSamePageTakingOverModel(model);
    }

    @GetMapping(value={"action"}, params={"action=searchAgain"})
    public String searchAgain(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, new SplibGeneralForm[]{searchForm, listForm});
        return this.redirectToSamePageTakingOverModel(model);
    }

    protected FST getProperSearchForm(Model model, FST searchForm) {
        String formName = this.getFunction() + "SearchForm";
        String key = this.getSessionKey(formName, searchForm);
        if (searchForm != null) {
            if (((SplibSearchForm)searchForm).isRequestFromSearchForm()) {
                this.request.getSession().setAttribute(key, searchForm);
            }
            if (this.request.getSession().getAttribute(key) == null) {
                this.request.getSession().setAttribute(key, searchForm);
            }
        } else if (this.request.getSession().getAttribute(formName) == null) {
            throw new RuntimeException("searchForm == null cannot be occurred.");
        }
        SplibSearchForm formUsedForSearch = (SplibSearchForm)this.request.getSession().getAttribute(this.getSessionKey(formName, searchForm));
        return (FST)formUsedForSearch;
    }

    private String getSessionKey(String formName, FST searchForm) {
        return formName + (String)(searchForm == null || ((SplibGeneralForm)searchForm).getDataKind() == null || ((SplibGeneralForm)searchForm).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)searchForm).getDataKind());
    }

    @GetMapping(value={"action"}, params={"conditionClear"})
    public String searchConditionClear(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        String formName = this.getFunction() + "SearchForm";
        String sessionKey = formName + (String)(((SplibGeneralForm)searchForm).getDataKind() == null || ((SplibGeneralForm)searchForm).getDataKind().equals("") ? "" : "." + ((SplibGeneralForm)searchForm).getDataKind());
        this.request.getSession().setAttribute(sessionKey, this.newSearchForm);
        this.prepare(model, loginUser, new SplibGeneralForm[]{searchForm, listForm});
        return new ReturnUrlBean(this, this.util, true).putParam("dataKind", ((SplibGeneralForm)searchForm).getDataKind()).getUrl();
    }

    @PostMapping(value={"action"}, params={"delete"})
    public String delete(Model model, FST searchForm, FLT listForm, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, loginUser, new SplibGeneralForm[]{searchForm, listForm});
        ((SplibSearchListService)this.getService()).delete(listForm, loginUser);
        return new ReturnUrlBean(this, this.util, true).showSuccessMessage().putParam("dataKind", ((SplibGeneralForm)listForm).getDataKind()).getUrl();
    }

    @PostMapping(value={"action"}, params={"showInsertForm"})
    public String showInsertForm(Model model, @AuthenticationPrincipal UserDetails loginUser) throws FormInputValidationException, AppException {
        this.prepare(model, loginUser, new SplibGeneralForm[0]);
        ReturnUrlBean bean = new ReturnUrlBean(this, this.util, "edit", "page").putParamMap(this.request.getParameterMap());
        return bean.getUrl();
    }

    @PostMapping(value={"action"}, params={"showUpdateForm"})
    public String showUpdateForm(Model model, @AuthenticationPrincipal UserDetails loginUser) throws FormInputValidationException, AppException {
        this.prepare(model, loginUser, new SplibGeneralForm[0]);
        ReturnUrlBean bean = new ReturnUrlBean(this, this.util, "edit", "page").putParamMap(this.request.getParameterMap());
        return bean.getUrl();
    }
}

