/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.form.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.ecuacion.splib.web.bean.HtmlField;
import jp.ecuacion.splib.web.bean.HtmlFieldNumber;
import jp.ecuacion.splib.web.util.SplibRecordUtil;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;

public interface RecordInterface {
    public HtmlField[] getHtmlFields();

    default public HtmlField getHtmlField(String fieldId) {
        return new SplibRecordUtil().getHtmlField(this.getHtmlFields(), fieldId);
    }

    default public boolean needsCommas(String itemName) {
        HtmlField item = Arrays.asList(this.getHtmlFields()).stream().collect(Collectors.toMap(e -> e.getId(), e -> e)).get(itemName);
        if (item == null || !(item instanceof HtmlFieldNumber)) {
            return false;
        }
        HtmlFieldNumber numItem = (HtmlFieldNumber)item;
        return numItem.getNeedsCommas();
    }

    default public String getDisplayName(String rootRecordId, String fieldId) {
        Map<String, String> displayNameIdMap;
        String displayNameId;
        HtmlField[] htmlFields;
        HtmlField[] htmlFieldArray = htmlFields = this.getHtmlFields() == null ? new HtmlField[]{} : this.getHtmlFields();
        if (fieldId.startsWith(rootRecordId + ".")) {
            fieldId = fieldId.substring((rootRecordId + ".").length());
        }
        displayNameId = (displayNameId = (displayNameIdMap = Arrays.asList(htmlFields).stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getDisplayNameId() == null ? e.getId() : e.getDisplayNameId()))).get(fieldId)) == null ? fieldId : displayNameId;
        return displayNameId.contains(".") ? displayNameId : rootRecordId + "." + displayNameId;
    }

    default public HtmlField[] mergeHtmlFields(HtmlField[] fields1, HtmlField[] fields2) {
        ArrayList<HtmlField> list = new ArrayList<HtmlField>(Arrays.asList(fields1));
        List<String> field1IdList = Arrays.asList(fields1).stream().map(e -> e.getId()).toList();
        for (String field2Id : Arrays.asList(fields2).stream().map(e -> e.getId()).toList()) {
            if (!field1IdList.contains(field2Id)) continue;
            throw new RuntimeException("'id' of HtmlField[] duplicated with commonHtmlFields. key: " + field2Id);
        }
        list.addAll(Arrays.asList(fields2));
        return list.toArray(new HtmlField[list.size()]);
    }

    default public List<String> getNotEmptyFields(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        HtmlField[] htmlFields;
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlField field : htmlFields = this.getHtmlFields()) {
            if (!field.getIsNotEmpty(loginState, bean)) continue;
            list.add(field.getId());
        }
        return list;
    }

    default public boolean isNotEmpty(String fieldName, String loginState, String rolesOrAuthoritiesString) {
        SplibSecurityUtil.RolesAndAuthoritiesBean bean = new SplibSecurityUtil().getRolesAndAuthoritiesBean(rolesOrAuthoritiesString);
        return this.getNotEmptyFields(loginState, bean).contains(fieldName);
    }
}

