package jp.ecuacion.splib.web.form;

/** 
 * Pagerを構成する1セルの情報が1PageInfo。
 */
public class PagerInfo {

  /** セルに表示する文字列。"Next"など。 */
  private String displayString;
  
  /** そのセルの状態を、bootstrapで使用する文字列でそのまま表現。"", "active", "disabled" のいずれか。 */
  private String status;
  
  /** リンクを押した時に飛ぶ先のページ番号。 */
  private String goToPage;
  
  /** disabledのセルを生成する際に使用するconstructor. */
  public PagerInfo(String displayString) {
    this.displayString = displayString;
    this.status = "disabled";
  }
  
  /** clickableセルを生成する際に使用するconstructor. */
  public PagerInfo(String displayString, boolean isActive, int goToPage) {
    this.displayString = displayString;
    this.status = (isActive) ? "active" : "";
    this.goToPage = Integer.toString(goToPage);
  }

  public String getDisplayString() {
    return displayString;
  }

  public void setDisplayString(String displayString) {
    this.displayString = displayString;
  }
  
  public String getStatus() {
    return status;
  }
  
  public void setStatus(String status) {
    this.status = status;
  }
  
  public boolean isDisabled() {
    return status.equals("disabled");
  }
  
  public String getGoToPage() {
    return goToPage;
  }
  
  public void setGoToPage(String goToPage) {
    this.goToPage = goToPage;
  }
}
