/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.service;

import java.util.Optional;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.jpa.entity.AbstractEntity;
import jp.ecuacion.splib.jpa.repository.SplibRepository;
import org.springframework.orm.ObjectOptimisticLockingFailureException;

public interface SplibJpaServiceInterface<E extends AbstractEntity> {
    public SplibRepository<E, Long> getRepositoryForOptimisticLocking();

    public String[] getVersionsForOptimisticLocking(E var1);

    default public E findAndOptimisticLockingCheck(String idOfRootRecord, String ... versionsInScreen) throws AppException {
        Optional optional = this.getRepositoryForOptimisticLocking().findById((Object)Long.valueOf(idOfRootRecord));
        if (optional.isEmpty()) {
            String msg = "jp.ecuacion.splib.web.common.message.sameRecordAlreadyDeleted";
            throw new BizLogicAppException(msg);
        }
        AbstractEntity e = (AbstractEntity)optional.get();
        if (!this.isVersionsTheSame(versionsInScreen, this.getVersionsForOptimisticLocking(e))) {
            throw new ObjectOptimisticLockingFailureException("some class", (Object)idOfRootRecord);
        }
        return (E)e;
    }

    private boolean isVersionsTheSame(String[] vers1, String[] vers2) {
        if (vers1 == null || vers2 == null) {
            throw new RuntimeException("Optimistic Locking check cannot be done because version array is null.");
        }
        if (vers1.length != vers2.length) {
            return false;
        }
        for (int i = 0; i < vers1.length; ++i) {
            if (vers1[i].equals(vers2[i])) continue;
            return false;
        }
        return true;
    }
}

