package jp.ecuacion.splib.web.util;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * thymeleaf側から呼ばれる想定のクラス。thymeleaf上で必要となる文字列処理を実施。
 */
@Component("strUtil")
public class SplibThymeleafStringUtil {
  
  /** 
   * acc -> getAccList, acc.name -> getAcc_NameListに変更。
   * "_"はrelation使用時のrepositoryの使用方法に準じた。
   */
  public String selectListMethodName(String itemName) {
    // "."で区切ったリストを作り、そのそれぞれの先頭をcapitalizeし、その後でリストの文字列を"_"を間に入れて結合。
    String[] strs = itemName.split("\\.");
    
    boolean is1st = true;
    StringBuilder rtn = new StringBuilder();
    for (String str : strs) {
      if (is1st) {
        is1st = false;
      } else {
        rtn.append("_");
      }
      
      rtn.append(StringUtils.capitalize(str));
    }
    
    return "get" + rtn.toString() + "List";
  }
}
