package jp.ecuacion.splib.web.controller;

import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.splib.web.form.AdminLoginForm;
import jp.ecuacion.splib.web.service.SplibGeneralDoNothingService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Scope("prototype")
@RequestMapping("/public/adminLogin")
public class AdminLoginController extends SplibGeneralController<SplibGeneralDoNothingService> {

  public AdminLoginController() {
    super("adminLogin");
  }

  /**
   * Session Timeout状態で、ログインボタンや他のPOST系ボタンを押す場合、session timeoutで弾かれ /public/login/accessDeined
   * にredirectされるが、そのredirectもPOSTで行われるため 本処理にPOSTで入ってくることがある。それを考慮し@RequestMappingにしておく。
   */
  @RequestMapping(value = "page", method = {RequestMethod.POST, RequestMethod.GET})
  public String page(Model model) throws BizLogicAppException {
    model.addAttribute("adminLoginForm", new AdminLoginForm());
    return "adminLogin";
  }
}
