package jp.ecuacion.splib.web.bean;

import jp.ecuacion.splib.web.form.record.StringMatchingConditionBean;
import jp.ecuacion.splib.web.form.record.StringMatchingConditionBean.StringMatchingPatternEnum;

public class HtmlItemString extends HtmlItem {

  protected StringMatchingConditionBean matchingCondition;

  public HtmlItemString(String itemName) {
    super(itemName);
    this.matchingCondition = new StringMatchingConditionBean();
  }

  @Override
  public HtmlItemString labelItemName(String labelItemName) {
    return (HtmlItemString) super.labelItemName(labelItemName);
  }

  @Override
  public HtmlItemString isNotEmpty(boolean isNotEmpty) {
    return (HtmlItemString) super.isNotEmpty(isNotEmpty);
  }

  @Override
  public HtmlItemString isNotEmpty(AuthKindEnum authKind, String authString, boolean isNotEmpty) {
    return (HtmlItemString) super.isNotEmpty(authKind, authString, isNotEmpty);
  }

  public HtmlItemString stringMatchingCondition(StringMatchingPatternEnum stringMatchingPattern,
      boolean ignoresCase) {
    this.matchingCondition = new StringMatchingConditionBean(stringMatchingPattern, ignoresCase);
    return this;
  }

  public StringMatchingPatternEnum getStringSearchPatternEnum() {
    return matchingCondition.getStringSearchPatternEnum();
  }

  public boolean isIgnoresCase() {
    return matchingCondition.isIgnoresCase();
  }
}
