package jp.ecuacion.splib.web.config;

import jakarta.servlet.SessionTrackingMode;
import java.util.Collections;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages = "jp.ecuacion.splib.core.config"
    + ",jp.ecuacion.splib.web.advice"
    + ",jp.ecuacion.splib.web.controller"
    + ",jp.ecuacion.splib.web.service"
    + ",jp.ecuacion.splib.web.util"
  )
public class SplibWebConfig {

  /**
   * 時々、URLが勝手に以下のように";" + jsessionIdが入り込み、";"が入ることでspring securityでエラーが発生しシステムエラーとなる。
   * 
   * <pre>
   * 問題のURL: https://aws-instance-manager.ecuacion.jp/aws-instance-manager/public/showPage/page;jsessionid=D51E9ED564B7148E81EE82C4E33EC70A?notFound=&page=home
   * 例外message： org.springframework.security.web.firewall.RequestRejectedException: 
   * The request was rejected because the URL contained a potentially malicious String ";"
   * </pre>
   * <p>
   * これを避けるため、以下の対応をとる。
   * https://code-kakikaki.com/springboot-url-jsessionid/
   * </p>
   */
  @Bean
  ServletContextInitializer servletContextInitializer() {
    ServletContextInitializer initializer = servletContext -> {
      servletContext.setSessionTrackingModes(Collections.singleton(SessionTrackingMode.COOKIE));
    };

    return initializer;
  }
}
