/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import jp.ecuacion.splib.web.bean.MessagesBean;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageOnSuccessBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.controller.SplibGeneral1FormController;
import jp.ecuacion.splib.web.controller.SplibGeneralController;
import jp.ecuacion.splib.web.form.SplibEditForm;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibEditService;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public abstract class SplibEditController<E extends SplibEditForm, S extends SplibEditService<E>>
extends SplibGeneral1FormController<E, S> {
    private static final String PARAM_INSERT = "showInsertForm";
    private static final String PARAM_UPDATE = "showUpdateForm";
    private PageTemplatePatternEnum pageTemplatePattern;
    protected RedirectUrlPathBean redirectPathOnSuccess;

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String function) {
        this(pageTemplatePattern, function, new SplibGeneralController.ControllerContext());
    }

    public SplibEditController(PageTemplatePatternEnum pageTemplatePattern, @Nonnull String function, SplibGeneralController.ControllerContext settings) {
        super(function, settings.subFunction("edit"));
        this.pageTemplatePattern = pageTemplatePattern;
    }

    @Override
    public String getDefaultSubFunctionOnSuccess() {
        return this.pageTemplatePattern == PageTemplatePatternEnum.SINGLE ? "edit" : "searchList";
    }

    @Override
    public String page(Model model, E form, @AuthenticationPrincipal UserDetails loginUser) {
        throw new RuntimeException("\"page\" needs params.");
    }

    @GetMapping(value={"page"}, params={"showInsertForm"})
    public String showInsertPage(Model model, E form, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.pageCommon(model, form, loginUser, true);
    }

    @GetMapping(value={"page"}, params={"showUpdateForm"})
    public String showUpdatePage(Model model, E form, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        return this.pageCommon(model, form, loginUser, false);
    }

    private String pageCommon(Model model, E form, UserDetails loginUser, boolean isInsert) throws Exception {
        this.prepare(model, loginUser, new SplibGeneralController.PrepareSettings().noRedirect(), new SplibGeneralForm[]{form});
        MessagesBean messageBean = (MessagesBean)model.getAttribute("responseMessages");
        if (messageBean.getErrorMessages().size() == 0) {
            ((SplibEditForm)form).setIsInsert(isInsert);
            ((SplibEditService)this.getService()).page(form, loginUser);
        }
        ((SplibEditService)this.getService()).prepareForm(form, loginUser);
        return this.getFunction() + "Edit";
    }

    @PostMapping(value={"action"}, params={"insertOrUpdate"})
    public String edit(@Validated E form, BindingResult result, Model model, @AuthenticationPrincipal UserDetails loginUser) throws Exception {
        this.prepare(model, loginUser, new SplibGeneralController.PrepareSettings().addParam(((SplibEditForm)form).isInsert() != false ? PARAM_INSERT : PARAM_UPDATE), ((SplibGeneralForm)form).validate(result));
        ((SplibEditService)this.getService()).edit(form, loginUser);
        RedirectUrlBean redirectBean = this.redirectPathOnSuccess == null ? new RedirectUrlPageOnSuccessBean() : this.redirectPathOnSuccess;
        redirectBean.putParam("dataKind", ((SplibGeneralForm)form).getDataKind());
        redirectBean.putParam(PARAM_UPDATE, ((SplibGeneralForm)form).getDataKind());
        return this.getReturnStringOnSuccess(redirectBean);
    }

    @PostMapping(value={"action"}, params={"back"})
    public String back(@Validated E editForm, BindingResult result, Model model) {
        boolean isSingle = this.pageTemplatePattern == PageTemplatePatternEnum.SINGLE;
        String retunPageFunction = isSingle ? "edit" : "searchList";
        RedirectUrlBean rtnBean = new RedirectUrlPageOnSuccessBean(retunPageFunction, "page").noSuccessMessage().putParam("dataKind", ((SplibGeneralForm)editForm).getDataKind());
        if (isSingle) {
            rtnBean.putParam(PARAM_UPDATE, (String)null);
        }
        return this.getReturnStringOnSuccess(rtnBean);
    }

    public static enum PageTemplatePatternEnum {
        SINGLE,
        PAIR_WITH_SEARCH_LIST;

    }
}

