package jp.ecuacion.splib.web.service;

import java.util.List;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class SplibGeneral1FormService<F extends SplibGeneralForm>
    extends SplibGeneralService {

  @Override
  @SuppressWarnings("unchecked")
  public void prepareForm(List<SplibGeneralForm> allFormList, UserDetails loginUser) {
    if (allFormList == null || allFormList.size() != 1) {
      throw new RuntimeException("The number of forms not match.");
    }

    SplibGeneralForm form = allFormList.get(0);
    prepareForm((F) form, loginUser);
  }

  public abstract void prepareForm(F form, UserDetails loginUser);

  public abstract void page(F form, UserDetails loginUser) throws Exception;
}
