/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.splib.web.bean.RedirectUrlBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPageBean;
import jp.ecuacion.splib.web.bean.RedirectUrlPathBean;
import jp.ecuacion.splib.web.bean.RequestResultBean;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.exception.InputValidationException;
import jp.ecuacion.splib.web.form.SplibGeneralForm;
import jp.ecuacion.splib.web.service.SplibGeneralService;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.resource.NoResourceFoundException;

public abstract class SplibGeneralController<G extends SplibGeneralForm>
extends SplibBaseController {
    public static final String KEY = "controller";
    protected RedirectUrlBean redirectUrlOnAppExceptionBean;
    private ControllerSettings settings;
    @Autowired
    private SplibUtil util;
    private StringUtil strUtil = new StringUtil();
    protected SplibSecurityUtil.RolesAndAuthoritiesBean rolesAndAuthoritiesBean;

    public static ControllerSettings newSettings() {
        return new ControllerSettings();
    }

    public abstract SplibGeneralService getService();

    public SplibGeneralController(@Nonnull String function) {
        this(function, SplibGeneralController.newSettings());
    }

    protected SplibGeneralController(@Nonnull String function, @NonNull ControllerSettings settings) {
        settings.function(function);
        this.settings = settings;
    }

    public String getFunction() {
        return this.settings.function();
    }

    public String getRootRecordName() {
        return this.settings.rootRecordName();
    }

    public RedirectUrlBean getRedirectUrlOnAppExceptionBean() {
        return this.redirectUrlOnAppExceptionBean;
    }

    @ModelAttribute
    private void setCommonParamsToModel(Model model, @AuthenticationPrincipal UserDetails loginUser) {
        model.addAttribute("function", (Object)this.settings.function());
        model.addAttribute("rootRecordName", (Object)this.settings.rootRecordName());
        this.rolesAndAuthoritiesBean = loginUser == null ? new SplibSecurityUtil().getRolesAndAuthoritiesBean() : new SplibSecurityUtil().getRolesAndAuthoritiesBean(loginUser);
        model.addAttribute("rolesAndAuthorities", (Object)this.rolesAndAuthoritiesBean);
    }

    protected String getReturnStringToShowPage() {
        return this.getDefaultHtmlFileName();
    }

    protected String getReturnStringOnSuccess(Model model) {
        return this.getReturnStringOnSuccess(model, this.getDefaultHtmlFileName(), true);
    }

    protected String getReturnStringOnSuccess(Model model, boolean needsSuccessMessage) {
        return this.getReturnStringOnSuccess(model, this.getDefaultHtmlFileName(), needsSuccessMessage);
    }

    protected String getReturnStringOnSuccess(Model model, String page) {
        return this.getReturnStringOnSuccess(model, page, true);
    }

    protected String getReturnStringOnSuccess(Model model, String page, boolean needsSuccessMessage) {
        if (needsSuccessMessage) {
            RequestResultBean bean = (RequestResultBean)model.getAttribute("responseMessages");
            bean.setNeedsSuccessMessage(true);
        }
        return page;
    }

    protected String getReturnStringOnSuccess(RedirectUrlBean redirectUrlBean) {
        if (redirectUrlBean instanceof RedirectUrlPageBean) {
            return ((RedirectUrlPageBean)redirectUrlBean).getUrl(this.util.getLoginState(), this.settings.function(), this.getDefaultSubFunctionOnSuccess(), this.getDefaultPageOnSuccess());
        }
        if (redirectUrlBean instanceof RedirectUrlPathBean) {
            return ((RedirectUrlPathBean)redirectUrlBean).getUrl();
        }
        throw new RuntimeException("RedirectUrlBean\u304c\u60f3\u5b9a\u5916\u306e\u5024\u3067\u3059\u3002" + String.valueOf(redirectUrlBean));
    }

    @GetMapping(value={"action"})
    public void throw404() throws NoResourceFoundException {
        throw new NoResourceFoundException(HttpMethod.GET, "from SplibGeneralController");
    }

    @RequestMapping(value={"action"}, params={"submitOnChangeToRefresh=true"}, method={RequestMethod.GET, RequestMethod.POST})
    public String submitOnChangeToRefresh(G form, Model model) throws Exception {
        this.prepare(model, new SplibGeneralForm[]{form});
        model.addAttribute(this.getFunction() + this.strUtil.capitalize(this.settings.subFunction()) + "Form", form);
        this.getService().prepareForm((SplibGeneralForm)form);
        return this.settings.function() + this.strUtil.capitalize(this.settings.subFunction());
    }

    public String getDefaultHtmlFileName() {
        return this.settings.function() + this.strUtil.capitalize(this.settings.htmlFilenamePostfix() == null ? this.settings.subFunction() : this.settings.htmlFilenamePostfix());
    }

    public String getDefaultSubFunctionOnSuccess() {
        return this.settings.subFunction();
    }

    public String getDefaultSubFunctionOnAppException() {
        return this.settings.subFunction();
    }

    public String getDefaultPageOnSuccess() {
        return "page";
    }

    public String getDefaultPageOnAppException() {
        return "page";
    }

    protected void prepare() throws InputValidationException, AppException {
        this.prepare(null, null, null, false, new SplibGeneralForm[0]);
    }

    protected void prepare(Model model, SplibGeneralForm ... nonValidationTargetForms) throws InputValidationException, AppException {
        this.prepare(model, null, null, false, nonValidationTargetForms);
    }

    protected void prepare(Model model, SplibGeneralForm validationTargetForm, BindingResult result, SplibGeneralForm ... nonValidationTargetForms) throws InputValidationException, AppException {
        this.prepare(model, validationTargetForm, result, true, nonValidationTargetForms);
    }

    private void prepare(Model model, SplibGeneralForm validationTargetForm, BindingResult result, boolean needsValidationCheck, SplibGeneralForm ... nonValidationTargetForms) throws InputValidationException, AppException {
        ArrayList<SplibGeneralForm> allFormList = new ArrayList<SplibGeneralForm>(Arrays.asList(nonValidationTargetForms));
        if (validationTargetForm != null) {
            allFormList.add(validationTargetForm);
        }
        for (SplibGeneralForm form : allFormList) {
            model.addAttribute((Object)form);
            this.getService().prepareForm(form);
        }
        this.request.setAttribute(KEY, (Object)this);
        this.transactionTokenCheck();
        if (needsValidationCheck) {
            this.validationCheck(validationTargetForm, result, this.util.getLoginState(), this.rolesAndAuthoritiesBean);
        }
    }

    protected void transactionTokenCheck() throws CustomizedValidationAppException {
        String tokenFromHtml = this.request.getParameter("transactionToken");
        Set tokenSet = (Set)this.request.getSession().getAttribute("transactionToken");
        if (tokenSet != null && tokenFromHtml != null) {
            if (!tokenSet.contains(tokenFromHtml)) {
                String msgId = "jp.ecuacion.splib.web.common.message.tokenInvalidate";
                throw new CustomizedValidationAppException(msgId);
            }
            tokenSet.remove(tokenFromHtml);
        }
    }

    private void validationCheck(SplibGeneralForm form, BindingResult result, String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) throws InputValidationException {
        boolean hasNotEmptyError = false;
        hasNotEmptyError = form.hasNotEmptyError(loginState, bean);
        if (hasNotEmptyError || result != null && result.hasErrors()) {
            throw new InputValidationException(form);
        }
    }

    public static class ControllerSettings {
        protected String function;
        protected String subFunction = "";
        protected String htmlFilenamePostfix;
        protected String rootRecordName;

        ControllerSettings() {
        }

        public ControllerSettings function(String function) {
            this.function = function;
            return this;
        }

        public String function() {
            return this.function;
        }

        public ControllerSettings subFunction(String subFunction) {
            this.subFunction = subFunction;
            return this;
        }

        public String subFunction() {
            return this.subFunction;
        }

        public ControllerSettings htmlFilenamePostfix(String htmlFilenamePostfix) {
            this.htmlFilenamePostfix = htmlFilenamePostfix;
            return this;
        }

        public String htmlFilenamePostfix() {
            return this.htmlFilenamePostfix;
        }

        public ControllerSettings rootRecordName(String rootRecordName) {
            this.rootRecordName = rootRecordName;
            return this;
        }

        public String rootRecordName() {
            return this.rootRecordName == null ? this.function : this.rootRecordName;
        }
    }
}

