/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import jp.ecuacion.splib.core.container.DatetimeFormatParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SplibUtil {
    @Autowired
    HttpServletRequest request;
    @Autowired
    private ServletContext servletContext;

    public DatetimeFormatParameters getParams(HttpServletRequest request) {
        DatetimeFormatParameters params = new DatetimeFormatParameters();
        String strOffset = (String)request.getSession().getAttribute("zoneOffset");
        if (strOffset == null) {
            strOffset = "0";
        }
        params.setZoneOffsetWithJsMinutes(Integer.valueOf(strOffset).intValue());
        return params;
    }

    public String getLoginState() {
        String tmp;
        Object loginState;
        String urlPathWithContextPath = this.request.getRequestURI();
        String contextPath = this.servletContext.getContextPath();
        if (!contextPath.equals("") && !contextPath.startsWith("/") || !urlPathWithContextPath.startsWith("/")) {
            throw new RuntimeException("servletContext.getContextPath() \u307e\u305f\u306f request.getRequestURI() \u304c\"\\\"\u304b\u3089\u59cb\u307e\u3063\u3066\u3044\u307e\u305b\u3093\u3002\u60f3\u5b9a\u5916\u3067\u3059\u3002servletContext.getContextPath() = " + contextPath + ", request.getRequestURI() = " + urlPathWithContextPath);
        }
        String urlPath = urlPathWithContextPath;
        if (!contextPath.equals("") && !contextPath.equals("/")) {
            urlPath = urlPath.replaceFirst(this.servletContext.getContextPath(), "");
        }
        if (((String)(loginState = (tmp = urlPath.substring(1)).substring(0, tmp.indexOf("/")))).equals("ecuacion")) {
            tmp = tmp.substring(tmp.indexOf("/") + 1);
            tmp = tmp.substring(0, tmp.indexOf("/"));
            loginState = (String)loginState + "-" + tmp;
        }
        ArrayList<String> loginStateCodeList = new ArrayList<String>();
        for (LoginStateEnum anEnum : LoginStateEnum.values()) {
            loginStateCodeList.add(anEnum.getCode());
        }
        if (!loginStateCodeList.contains(loginState)) {
            new RuntimeException("loginState not appropriate: loginState = " + (String)loginState + ", urlPath = " + urlPath);
        }
        return loginState;
    }

    public static enum LoginStateEnum {
        PUBLIC("public"),
        ACCOUNT("account"),
        ADMIN("admin"),
        ECUACION_PUBLIC("ecuacion-public");

        private String code;

        private LoginStateEnum(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

