package jp.ecuacion.splib.web.form.record;

import java.util.ResourceBundle;
import jp.ecuacion.lib.core.form.record.AbstractRecord;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.web.bean.HtmlItem;

public class ConfigRecord extends AbstractRecord implements RecordInterface {
  private static final String codeGeneratorNotUsedMesssage = "(code-generator not used)";

  @Override
  public HtmlItem[] getHtmlItems() {
    return new HtmlItem[] {};
  }

  public String getAppVersion() {
    return ResourceBundle.getBundle("version").getString("project.version");
  }

  public String getExcelTemplateVersion() {
    return getCodeGeneratorRelatedValue("EXCEL_TEMPLATE_VERSION");
  }

  public String getCodeGeneratorVersion() {
    return getCodeGeneratorRelatedValue("CODE_GENERATOR_VERSION");
  }

  private String getCodeGeneratorRelatedValue(String key) {
    boolean hasValue = PropertyFileUtil.hasApp(key);
    return hasValue ? PropertyFileUtil.getApp(key) : codeGeneratorNotUsedMesssage;
  }

}
