package jp.ecuacion.splib.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jp.ecuacion.lib.core.util.LogUtil;
import jp.ecuacion.splib.web.advice.SplibControllerAdvice;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("/public/error")
public class SplibErrorController implements ErrorController {

  @RequestMapping(produces = MediaType.TEXT_HTML_VALUE,
      method = {RequestMethod.POST, RequestMethod.GET})
  public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response,
      Model model) {

    // requestに設定されているmodelを追加登録（画面描画のためのparameterもあるので）
    model.addAllAttributes(
        ((Model) request.getAttribute(SplibControllerAdvice.REQUEST_KEY_MODEL)).asMap());

    Integer statusCode = (Integer) request.getAttribute("jakarta.servlet.error.status_code");
    Exception exception = (Exception) request.getAttribute("jakarta.servlet.error.exception");

    new LogUtil(this).logErr(exception);

    // new DetailLogger(this).
    return new ModelAndView("error", model.asMap(), HttpStatus.valueOf(statusCode));
  }
}
