package jp.ecuacion.splib.web.util;

import jp.ecuacion.lib.core.exception.checked.CustomizedValidationAppException;
import jp.ecuacion.lib.core.logging.ErrorLogger;
import org.springframework.stereotype.Component;

/** thymeleaf側から明示的にシステムエラーを発生させたい際に使用。 */
@Component("exUtil")
public class SplibThymeleafExceptionUtil {
  
  private ErrorLogger errorLogger = new ErrorLogger(this);
  
  public void systemError(String message) throws CustomizedValidationAppException {
    // どのようなエラーハンドリングをするかはアプリにもよるのでsplib内のモジュールに具体的なhandling処理を書くことはできない。
    // ログのみ出力としておく。
    errorLogger.fatal("An error occured while thymeleaf constructs an html : " + message);
    
    throw new RuntimeException(message);
  }
}
