/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.core.userdetails.UserDetails;

public class SplibSecurityUtil {
    public RolesAndAuthoritiesBean getRolesAndAuthoritiesBean() {
        return this.createRolesAndAuthoritiesBean(new ArrayList<String>());
    }

    public RolesAndAuthoritiesBean getRolesAndAuthoritiesBean(UserDetails userDetails) {
        List<String> list = userDetails.getAuthorities().stream().map(e -> e.getAuthority()).toList();
        return this.createRolesAndAuthoritiesBean(list);
    }

    public RolesAndAuthoritiesBean getRolesAndAuthoritiesBean(String rolesOrAuthoritiesString) {
        rolesOrAuthoritiesString = rolesOrAuthoritiesString.replace("[", "").replace("]", "").replace(" ", "");
        return this.createRolesAndAuthoritiesBean(Arrays.asList(rolesOrAuthoritiesString.split(",")));
    }

    private RolesAndAuthoritiesBean createRolesAndAuthoritiesBean(List<String> list) {
        ArrayList<String> roleList = new ArrayList<String>();
        ArrayList<String> authorityList = new ArrayList<String>();
        for (String authorityOrRole : list) {
            if (authorityOrRole.startsWith("ROLE_")) {
                roleList.add(authorityOrRole.substring(5));
                continue;
            }
            authorityList.add(authorityOrRole);
        }
        return new RolesAndAuthoritiesBean(roleList, authorityList);
    }

    public static class RolesAndAuthoritiesBean {
        private List<String> roleList;
        private List<String> authorityList;

        public RolesAndAuthoritiesBean(List<String> roleList, List<String> authorityList) {
            this.roleList = roleList;
            this.authorityList = authorityList;
        }

        public List<String> getRoleList() {
            return this.roleList;
        }

        public List<String> getAuthorityList() {
            return this.authorityList;
        }
    }
}

